/**
 * @preserve
 * Plugin Name: dflip
 * Description: dflip - 3D & 2D FlipBook
 *
 * Author: Deepak Ghimire
 * Author URI: http://dearhive.com
 */
"use strict";var DFLIP=DFLIP||{},PRESENTATION=DFLIP;!function(e,t){e.version="1.7.25",e.PAGE_MODE={SINGLE:1,DOUBLE:2,AUTO:null},e.SINGLE_PAGE_MODE={ZOOM:1,BOOKLET:2,AUTO:null},e.CONTROLSPOSITION={HIDDEN:"hide",TOP:"top",BOTTOM:"bottom"},e.DIRECTION={LTR:1,RTL:2},e.LINK_TARGET={NONE:0,SELF:1,BLANK:2,PARENT:3,TOP:4},e.CORNERS={TL:"tl",TR:"tr",BL:"bl",BR:"br",L:"l",R:"r",NONE:null},e.SOURCE_TYPE={IMAGE:"image",PDF:"pdf",HTML:"html"},e.DISPLAY_TYPE={WEBGL:"3D",HTML:"2D"},e.PAGE_SIZE={AUTO:0,SINGLE:1,DOUBLEINTERNAL:2};var n,i,o,a,s=e.defaults={webgl:!0,webglShadow:!0,soundEnable:!0,search:!1,height:"auto",autoEnableOutline:!1,autoEnableThumbnail:!1,overwritePDFOutline:!1,enableDownload:!0,duration:800,direction:e.DIRECTION.LTR,pageMode:e.PAGE_MODE.AUTO,singlePageMode:e.SINGLE_PAGE_MODE.AUTO,backgroundColor:"#fff",forceFit:!0,transparent:!1,hard:"none",openPage:1,annotationClass:"",autoPlay:!1,autoPlayDuration:5e3,autoPlayStart:!1,maxTextureSize:1600,minTextureSize:256,rangeChunkSize:524288,icons:{altnext:"ti-angle-right",altprev:"ti-angle-left",next:"ti-angle-right",prev:"ti-angle-left",end:"ti-angle-double-right",start:"ti-angle-double-left",share:"ti-sharethis",help:"ti-help-alt",more:"ti-more-alt",download:"ti-download",zoomin:"ti-zoom-in",zoomout:"ti-zoom-out",fullscreen:"ti-fullscreen",fitscreen:"ti-arrows-corner",thumbnail:"ti-layout-grid2",outline:"ti-menu-alt",close:"ti-close",search:"ti-search",doublepage:"ti-book",singlepage:"ti-file",sound:"ti-volume",facebook:"ti-facebook",google:"ti-google",twitter:"ti-twitter-alt",mail:"ti-email",play:"ti-control-play",pause:"ti-control-pause"},text:{toggleSound:"Turn on/off Sound",toggleThumbnails:"Toggle Thumbnails",toggleOutline:"Toggle Outline/Bookmark",previousPage:"Previous Page",nextPage:"Next Page",toggleFullscreen:"Toggle Fullscreen",zoomIn:"Zoom In",zoomOut:"Zoom Out",toggleHelp:"Toggle Help",singlePageMode:"Single Page Mode",doublePageMode:"Double Page Mode",downloadPDFFile:"Download PDF File",gotoFirstPage:"Goto First Page",gotoLastPage:"Goto Last Page",play:"Start AutoPlay",pause:"Pause AutoPlay",share:"Share",mailSubject:"I wanted you to see this FlipBook",mailBody:"Check out this site {{url}}",loading:"Loading"},allControls:"altPrev,pageNumber,altNext,play,outline,thumbnail,zoomIn,zoomOut,fullScreen,share,download,search,more,pageMode,startPage,endPage,sound",moreControls:"download,pageMode,startPage,endPage,sound",hideControls:"",controlsPosition:e.CONTROLSPOSITION.BOTTOM,paddingTop:30,paddingLeft:20,paddingRight:20,paddingBottom:30,enableAnalytics:!1,scrollWheel:!0,onCreate:function(e){},onCreateUI:function(e){},onFlip:function(e){},beforeFlip:function(e){},onReady:function(e){},zoomRatio:1.5,pageSize:e.PAGE_SIZE.AUTO,pdfjsSrc:"js/libs/pdf.min.js",pdfjsCompatibilitySrc:"js/libs/compatibility.js",pdfjsWorkerSrc:"js/libs/pdf.worker.min.js",threejsSrc:"js/libs/three.min.js",mockupjsSrc:"js/libs/mockup.min.js",soundFile:"sound/turn2.mp3",imagesLocation:"images",imageResourcesPath:"images/pdfjs/",cMapUrl:"cmaps/",enableDebugLog:!1,canvasToBlob:!1,enableAnnotation:!0,pdfRenderQuality:.9,textureLoadFallback:"blank",stiffness:3,backgroundImage:"",pageRatio:null,pixelRatio:window.devicePixelRatio||1,thumbElement:"div",spotLightIntensity:.22,ambientLightColor:"#fff",ambientLightIntensity:.8,shadowOpacity:.15,linkTarget:e.LINK_TARGET.BLANK,sharePrefix:"flipbook-",loadMoreCount:!1},r="WebKitCSSMatrix"in window||document.body&&"MozPerspective"in document.body.style,l="onmousedown"in window,c=(window,navigator.userAgent),d=e.utils={drag:{left:0,right:1,none:-1},mouseEvents:l?{type:"mouse",start:"mousedown",move:"mousemove",end:"mouseup"}:{type:"touch",start:"touchstart",move:"touchmove",end:"touchend"},html:{div:"<div/>",img:"<img/>",a:"<a>",input:"<input type='text'/>"},getSharePrefix:function(){return d.getSharePrefixes()[0]},getSharePrefixes:function(){return(e.defaults.sharePrefix+",dflip-,flipbook-,dearflip-").split(",").filter((function(e){return e}))},toRad:function(e){return e*Math.PI/180},isset:function(e,t){return null==e?t:e},isnull:function(e){return null==e||null==e},toDeg:function(e){return 180*e/Math.PI},transition:function(e,t){return e?t/1e3+"s ease-out":"0s none"},hasCompatibility:function(){var e=!1;return null!=window.dFlipLocation&&window.dFlipLocation.indexOf("lip-lit")>0&&(e=!0),e},scrollIntoView:function(e,t,n){(t=t||e.parentNode).scrollTop=e.offsetTop-t.offsetTop+(!1===n?e.offsetHeight-t.offsetHeight:0),t.scrollLeft=e.offsetLeft-t.offsetLeft},display:function(e){return e?"block":"none"},resetTranslate:function(){return b(0,0)},translateStr:function(e,t){return r?" translate3d("+e+"px,"+t+"px, 0px) ":" translate("+e+"px, "+t+"px) "},httpsCorrection:function(e){var t=window.location;return t.href.indexOf("https://")>-1&&e.indexOf(t.hostname)>-1&&(e=e.replace("http://","https://")),t.href.indexOf("http://")>-1&&e.indexOf(t.hostname)>-1&&(e=e.replace("https://","http://")),e},resetBoxShadow:function(){return"rgba(0, 0, 0, 0) 0px 0px 20px"},rotateStr:function(e){return" rotateZ("+e+"deg) "},bg:function(e){return"#fff"+P(e)},bgImage:function(e){return null==e||"blank"==e?"":" url("+e+")"},src:function(e){return null!=e?""+e:""},limitAt:function(e,t,n){return e<t?t:e>n?n:e},distOrigin:function(e,t){return Math.sqrt(Math.pow(e,2)+Math.pow(t,2))},distPoints:function(e,t,n,i){return Math.sqrt(Math.pow(n-e,2)+Math.pow(i-t,2))},calculateScale:function(e,t){var n=C(e[0].x,e[0].y,e[1].x,e[1].y);return C(t[0].x,t[0].y,t[1].x,t[1].y)/n},getVectorAvg:function(e){return{x:e.map((function(e){return e.x})).reduce(d.sum)/e.length,y:e.map((function(e){return e.y})).reduce(d.sum)/e.length}},sum:function(e,t){return e+t},getTouches:function(e,t){return t=t||{left:0,top:0},Array.prototype.slice.call(e.touches).map((function(e){return{x:e.pageX-t.left,y:e.pageY-t.top}}))},angleByDistance:function(e,t){var n=t/2,i=x(e,0,t);return i<n?v(Math.asin(i/n)):90+v(Math.asin((i-n)/n))},log:function(e){1==s.enableDebugLog&&window.console&&console.log(e)},lowerPowerOfTwo:function(e){return Math.pow(2,Math.floor(Math.log(e)/Math.LN2))},nearestPowerOfTwo:function(e,t){return Math.min(t||2048,Math.pow(2,Math.ceil(Math.log(e)/Math.LN2)))},zoomStops:function(e,t,n,i,o){null==i&&(i=256),null==o&&(o=2048);var a=Math.log(e/i)/Math.log(t);return i*Math.pow(t,null==n?Math.round(a):1==n?Math.ceil(a):Math.floor(a))},extendOptions:function(e,n){return t.extend(!0,{},e,n)},getFullscreenElement:function(){return document.fullscreenElement||document.mozFullScreenElement||document.webkitFullscreenElement||document.msFullscreenElement},hasFullscreenEnabled:function(){return document.fullscreenEnabled||document.mozFullScreenEnabled||document.webkitFullscreenEnabled||document.msFullscreenEnabled},getBasePage:function(e){return 2*Math.floor(e/2)},loadResources:function(e,t,n){var i=document,o=i.createElement(e),a=i.getElementsByTagName(e)[0];o.async=!0,n&&o.addEventListener("load",(function(e){n(null,e)}),!1),o.src=t,a.parentNode.insertBefore(o,a)},getScriptCallbacks:[],getScript:function(e,n,i){var o,a=d.getScriptCallbacks[e];function s(e,t){if(null!=o&&(t||!o.readyState||/loaded|complete/.test(o.readyState))&&(o.onload=o.onreadystatechange=null,o=null,o=null,!t)){for(var n=0;n<a.length;n++)a[n]&&a[n](),a[n]=null;i=null}}if(0===t("script[src='"+e+"']").length){(a=d.getScriptCallbacks[e]=[]).push(n),o=document.createElement("script");var r=document.body.getElementsByTagName("script")[0];o.async=1,o.setAttribute("data-cfasync",!1),null!=r?(r.parentNode.insertBefore(o,r),r=null):document.body.appendChild(o),o.addEventListener("load",s,!1),o.addEventListener("readystatechange",s,!1),o.addEventListener("complete",s,!1),i&&o.addEventListener("error",i,!1),o.src=e+("MS"==R.dom?"?"+Math.random(1):"")}else a.push(n)},isHardPage:function(e,t,n,i){if(null!=e){if("cover"==e)return 0==t||i&&1==t||t==Math.ceil(n/(i?1:2))-(i?0:1);if("all"==e)return!0;var o=(","+e+",").indexOf(","+(2*t+1)+",")>-1,a=(","+e+",").indexOf(","+(2*t+2)+",")>-1;return o||a}return!1},fixMouseEvent:function(e){if(e){var n=e.originalEvent||e;if(n.changedTouches&&n.changedTouches.length>0){var i=t.event.fix(e),o=n.changedTouches[0];return i.clientX=o.clientX,i.clientY=o.clientY,i.pageX=o.pageX,i.touches=n.touches,i.pageY=o.pageY,i.movementX=o.movementX,i.movementY=o.movementY,i}return e}return e},hasWebgl:function(){try{var e=document.createElement("canvas");return!(!window.WebGLRenderingContext||!e.getContext("webgl")&&!e.getContext("experimental-webgl"))}catch(e){return!1}}(),isBookletMode:function(t){return t.pageMode==e.PAGE_MODE.SINGLE&&t.singlePageMode==e.SINGLE_PAGE_MODE.BOOKLET},isRTLMode:function(t){return t.direction==e.DIRECTION.RTL},isIPad:navigator.maxTouchPoints&&navigator.maxTouchPoints>2&&/MacIntel/.test(navigator.platform),isMobile:(a=!1,o=c||navigator.vendor||window.opera,(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino|android|ipad|playbook|silk/i.test(o)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(o.substr(0,4)))&&(a=!0),a),isIOS:/(iPad|iPhone|iPod)/g.test(c),isSafari:/constructor/i.test(window.HTMLElement)||"[object SafariRemoteNotification]"===(!window.safari||safari.pushNotification).toString(),prefix:(n=window.getComputedStyle(document.documentElement,""),i=Array.prototype.slice.call(n).join("").match(/-(moz|webkit|ms)-/)[1],{dom:"WebKit|Moz|MS".match(new RegExp("("+i+")","i"))[1],lowercase:i,css:"-"+i+"-",js:i[0].toUpperCase()+i.substr(1)}),canSupport3D:function(){var e=!0;try{if(-1!==c.indexOf("MSIE")||navigator.appVersion.indexOf("Trident/")>0)e=!1,console.log("Proper Support for 3D not detected for IE!");else if(z&&!B)e=!1,console.log("Proper Support for 3D not detected for IOS!");else{var t=c.toString().toLowerCase().match(/android\s([0-9\.]*)/i);(t=t?t[1]:void 0)&&(t=parseInt(t,10),!isNaN(t)&&t<9&&(e=!1,console.log("Proper Support for 3D not detected for Android below 9.0!")))}}catch(e){}return e},__extends:function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n]);function i(){this.constructor=e}return i.prototype=t.prototype,e.prototype=new i,e.__super=t.prototype,e}},u=e.SOURCE_TYPE,h=(e.DISPLAY_TYPE,d.drag),p=d.mouseEvents,g=d.html,f=d.isset,m=(d.isnull,d.toRad),v=d.toDeg,b=(d.transition,d.translateStr),w=(d.resetBoxShadow,d.rotateStr),P=(d.bg,d.bgImage),x=(d.src,d.limitAt),y=d.distOrigin,C=d.distPoints,L=d.angleByDistance,S=d.log,I=d.nearestPowerOfTwo,E=d.extendOptions,k=d.getBasePage,T=d.getScript,O=d.fixMouseEvent,R=d.prefix,F=d.isBookletMode,M=d.isRTLMode,D=d.isMobile,N=d.hasWebgl,z=d.isSafari,B=d.isIOS,_=d.__extends;!function(){if(window.CanvasPixelArray)"function"!=typeof window.CanvasPixelArray.prototype.set&&(window.CanvasPixelArray.prototype.set=function(e){for(var t=0,n=this.length;t<n;t++)this[t]=e[t]});else{var e,t=!1;if(z&&(t=(e=c.match(/Version\/([0-9]+)\.([0-9]+)\.([0-9]+) Safari\//))&&parseInt(e[1])<6),t){var n=window.CanvasRenderingContext2D.prototype,i=n.createImageData;n.createImageData=function(e,t){var n=i.call(this,e,t);return n.data.set=function(e){for(var t=0,n=this.length;t<n;t++)this[t]=e[t]},n},n=null}}}(),"requestAnimationFrame"in window||(window.requestAnimationFrame=window.mozRequestAnimationFrame||window.webkitRequestAnimationFrame||function(e){window.setTimeout(e,20)}),function(){if("undefined"!=typeof Uint8Array)return void 0===Uint8Array.prototype.subarray&&(Uint8Array.prototype.subarray=function(e,t){return new Uint8Array(this.slice(e,t))},Float32Array.prototype.subarray=function(e,t){return new Float32Array(this.slice(e,t))}),void("undefined"==typeof Float64Array&&(window.Float64Array=Float32Array));function e(e,t){return new n(this.slice(e,t))}function t(e,t){arguments.length<2&&(t=0);for(var n=0,i=e.length;n<i;++n,++t)this[t]=255&e[n]}function n(n){var i,o,a;if("number"==typeof n)for(i=[],o=0;o<n;++o)i[o]=0;else if("slice"in n)i=n.slice(0);else for(i=[],o=0,a=n.length;o<a;++o)i[o]=n[o];return i.subarray=e,i.buffer=i,i.byteLength=i.length,i.set=t,"object"==typeof n&&n.buffer&&(i.buffer=n.buffer),i}window.Uint8Array=n,window.Int8Array=n,window.Uint32Array=n,window.Int32Array=n,window.Uint16Array=n,window.Float32Array=n,window.Float64Array=n}();var A=function(n,i){var o="df-ui",a=M(i.target),s=i.ui=t(g.div,{class:o}),r=i.options;s.dispose=function(){n.find(".df-ui-btn").each((function(){t(this).off()})),w.off(),c.off(),u.off(),h.off(),p.off(),f.off(),m.off(),v.off(),P.off(),C.off(),k.off(),T.off(),R.off(),F.off(),N.off(),z.off(),_.off(),A.off(),j.off(),U.off(),O.remove(),b.remove(),u.remove(),c.remove(),p.remove(),s.shareBox&&(s.shareBox.dispose&&s.shareBox.dispose(),s.shareBox=null),document.removeEventListener("keyup",Y,!1),window.removeEventListener("click",L,!1),s.update=null,i=null};var l=function(e){return isNaN(e)?e=i.target._activePage:e<1?e=1:e>i.target.pageCount&&(e=i.target.pageCount),e},c=s.next=t(g.div,{class:"df-ui-btn df-ui-next "+r.icons.next,title:a?r.text.previousPage:r.text.nextPage,html:"<span>"+r.text.nextPage+"</span>"}).on("click",(function(){i.next()})),u=s.prev=t(g.div,{class:"df-ui-btn df-ui-prev "+r.icons.prev,title:a?r.text.nextPage:r.text.previousPage,html:"<span>"+r.text.previousPage+"</span>"}).on("click",(function(){i.prev()})),h=t(g.div,{class:"df-ui-btn df-ui-play "+r.icons.play,title:r.text.play,html:"<span>"+r.text.play+"</span>"}).on("click",(function(){var e=t(this);i.setAutoPlay(!e.hasClass(r.icons.pause))}));1==r.autoPlay&&(s.play=h,i.setAutoPlay(r.autoPlayStart));var p=t(g.div,{class:"df-ui-wrapper df-ui-zoom"}),f=s.zoomIn=t(g.div,{class:"df-ui-btn df-ui-zoomin "+r.icons.zoomin,title:r.text.zoomIn,html:"<span>"+r.text.zoomIn+"</span>"}).on("click",(function(){i.zoom(1),s.update(),i.target.startPoint&&i.target.pan&&i.target.pan(i.target.startPoint)})),m=s.zoomOut=t(g.div,{class:"df-ui-btn df-ui-zoomout "+r.icons.zoomout,title:r.text.zoomOut,html:"<span>"+r.text.zoomOut+"</span>"}).on("click",(function(){i.zoom(-1),s.update(),i.target.startPoint&&i.target.pan&&i.target.pan(i.target.startPoint)}));p.append(f).append(m);var v=s.pageNumber=t(g.div,{class:"df-ui-btn df-ui-page"}).on("change",(function(){var e=parseInt(s.pageInput.val(),10);e=l(e),i.gotoPage(e)})).on("keyup",(function(e){if(13==e.keyCode){var t=parseInt(s.pageInput.val(),10);(t=l(t))!==l(i.target._activePage||i._activePage)&&i.gotoPage(t)}}));s.pageInput=t('<input id="df_book_page_number" type="text"/>').appendTo(v),s.pageLabel=t('<label for="df_book_page_number"/>').appendTo(v);var b=t(g.div,{class:"df-ui-wrapper df-ui-size"}),w=t(g.div,{class:"df-ui-btn df-ui-help "+r.icons.help,title:r.text.toggleHelp,html:"<span>"+r.text.toggleHelp+"</span>"}).on("click",(function(){})),P=s.sound=t(g.div,{class:"df-ui-btn df-ui-sound "+r.icons.sound,title:r.text.toggleSound,html:"<span>"+r.text.toggleSound+"</span>"}).on("click",(function(){r.soundEnable=!r.soundEnable,s.updateSound()}));if(s.updateSound=function(){0==r.soundEnable||"false"==r.soundEnable?P.addClass("disabled"):P.removeClass("disabled")},s.updateSound(),"string"==typeof r.source&&1==r.search){var x=s.search=t(g.div,{class:"df-ui-btn df-ui-search "+r.icons.search}).on("click",(function(e){x.hasClass("df-active")||(t(this).addClass("df-active"),e.stopPropagation())}));window.addEventListener("click",(function(e){s.search.removeClass("df-active")}),!1);var y=t(g.div,{class:"search-container"});x.append(y)}var C=s.more=t(g.div,{class:"df-ui-btn df-ui-more "+r.icons.more}).on("click",(function(e){C.hasClass("df-active")||(t(this).addClass("df-active"),e.stopPropagation())}));function L(e){C.removeClass("df-active")}window.addEventListener("click",L,!1);var I=t(g.div,{class:"more-container"});if(C.append(I),"string"==typeof r.source&&1==r.enableDownload){var E="df-ui-btn df-ui-download "+r.icons.download;(s.download=t('<a download target="_blank" class="'+E+'"><span>'+r.text.downloadPDFFile+"</span></a>")).attr("href",r.source).attr("title",r.text.downloadPDFFile)}d.hasFullscreenEnabled()||n.addClass("df-custom-fullscreen"),s.switchFullscreen=function(){d.getFullscreenElement();var e=i.container[0];1!=s.isFullscreen?(i.container.addClass("df-fullscreen"),e.requestFullscreen?e.requestFullscreen():e.msRequestFullscreen?e.msRequestFullscreen():e.mozRequestFullScreen?e.mozRequestFullScreen():e.webkitRequestFullscreen&&e.webkitRequestFullscreen(),s.isFullscreen=!0):(i.container.removeClass("df-fullscreen"),s.isFullscreen=!1,document.exitFullscreen?document.fullscreenElement&&document.exitFullscreen():document.msExitFullscreen?document.msExitFullscreen():document.mozCancelFullScreen?document.fullscreenElement&&document.mozCancelFullScreen():document.webkitExitFullscreen&&document.webkitExitFullscreen()),d.hasFullscreenEnabled()||setTimeout((function(){i.resize()}),50)};var k=s.fullScreen=t(g.div,{class:"df-ui-btn df-ui-fullscreen "+r.icons.fullscreen,title:r.text.toggleFullscreen,html:"<span>"+r.text.toggleFullscreen+"</span>"}).on("click",s.switchFullscreen),T=s.fit=t(g.div,{class:"df-ui-btn df-ui-fit "+r.icons.fitscreen}).on("click",(function(){t(this).toggleClass("df-button-fit-active")}));b.append(k);var O=t(g.div,{class:"df-ui-wrapper df-ui-controls"}),R=(s.shareBox=new e.Share(n,r),s.share=t(g.div,{class:"df-ui-btn df-ui-share "+r.icons.share,title:r.text.share,html:"<span>"+r.text.share+"</span>"}).on("click",(function(e){1==s.shareBox.isOpen?s.shareBox.close():(s.shareBox.update(i.getURLHash()),s.shareBox.show())}))),F=s.startPage=t(g.div,{class:"df-ui-btn df-ui-start "+(a?r.icons.end:r.icons.start),title:r.text.gotoFirstPage,html:"<span>"+r.text.gotoFirstPage+"</span>"}).on("click",(function(){i.start()})),N=s.endPage=t(g.div,{class:"df-ui-btn df-ui-end "+(a?r.icons.start:r.icons.end),title:r.text.gotoLastPage,html:"<span>"+r.text.gotoLastPage+"</span>"}).on("click",(function(){i.end()})),z=s.pageMode=t(g.div,{class:"df-ui-btn df-ui-pagemode "+r.icons.singlepage,html:"<span>"+r.text.singlePageMode+"</span>"}).on("click",(function(){var e=t(this);i.setPageMode(!e.hasClass(r.icons.doublepage))}));i.setPageMode(i.target.pageMode==e.PAGE_MODE.SINGLE);var _=s.altPrev=t(g.div,{class:"df-ui-btn df-ui-prev df-ui-alt "+r.icons.prev,title:a?r.text.nextPage:r.text.previousPage,html:"<span>"+r.text.previousPage+"</span>"}).on("click",(function(){i.prev()})),A=s.altNext=t(g.div,{class:"df-ui-btn df-ui-next df-ui-alt "+r.icons.next,title:a?r.text.previousPage:r.text.nextPage,html:"<span>"+r.text.nextPage+"</span>"}).on("click",(function(){i.next()})),j=s.thumbnail=t(g.div,{class:"df-ui-btn df-ui-thumbnail "+r.icons.thumbnail,title:r.text.toggleThumbnails,html:"<span>"+r.text.toggleThumbnails+"</span>"}).on("click",(function(){var e=t(this);i.target.thumbContainer?(i.target.thumbContainer.toggleClass("df-sidemenu-visible"),e.toggleClass("df-active")):(i.contentProvider.initThumbs(),e.toggleClass("df-active"));e.hasClass("df-active")&&e.siblings(".df-active").trigger("click"),s.update(!0)})),U=s.outline=t(g.div,{class:"df-ui-btn df-ui-outline "+r.icons.outline,title:r.text.toggleOutline,html:"<span>"+r.text.toggleOutline+"</span>"}).on("click",(function(){var e=t(this);if(i.target.outlineContainer){var n=i.target.outlineContainer;e.toggleClass("df-active"),n.toggleClass("df-sidemenu-visible"),e.hasClass("df-active")&&e.siblings(".df-active").trigger("click"),s.update(!0)}})),H=r.allControls.replace(/ /g,"").split(","),W=","+r.moreControls.replace(/ /g,"")+",",V=","+r.hideControls.replace(/ /g,"")+",";B&&D&&(V+=",fullScreen,");W.split(",");for(var G=0;G<H.length;G++){var q=H[G];if(V.indexOf(","+q+",")<0){var Z=s[q];null!=Z&&"object"==typeof Z&&(W.indexOf(","+q+",")>-1&&"more"!==q&&"pageNumber"!==q?I.append(Z):O.append(Z))}}n.append(O).append(u).append(c).append(p);function Y(e){switch(e.keyCode){case 27:1==s.isFullscreen?s.fullScreen.trigger("click"):window.dfLightBox&&window.dfActiveLightBoxBook&&window.dfLightBox.closeButton.trigger("click");break;case 16:!1;break;case 17:!1;break;case 18:!1;break;case 37:i.prev();break;case 39:i.next()}}document.addEventListener("keyup",Y,!1),s.update=function(t){S("ui update");var o=i.target,a=l(o._activePage||i._activePage),r=o.pageCount||i.pageCount,c=o.direction==e.DIRECTION.RTL,d=1==a||0==a,u=a==r;s.next.show(),s.prev.show(),s.altNext.removeClass("disabled"),s.altPrev.removeClass("disabled"),(d&&!c||u&&c)&&(s.prev.hide(),s.altPrev.addClass("disabled")),(u&&!c||d&&c)&&(s.next.hide(),s.altNext.addClass("disabled")),s.pageInput.val(a),s.pageLabel.html(a+"/"+r),n.find(".df-sidemenu-visible").length>0?n.addClass("df-sidemenu-open"):n.removeClass("df-sidemenu-open"),1==t&&i.resize(),o.contentProvider.zoomScale==o.contentProvider.maxZoom?s.zoomIn.addClass("disabled"):s.zoomIn.removeClass("disabled"),1==o.contentProvider.zoomScale?s.zoomOut.addClass("disabled"):s.zoomOut.removeClass("disabled")},null!=i.target&&(i.target.ui=s),null!=r.onCreateUI&&r.onCreateUI(i)},j=null;function U(){j=function(e){function n(n){n=n||{};var i=this;e.call(this,n),i.options=n,i.canvas=t(i.renderer.domElement).addClass("df-3dcanvas"),i.container=n.container,i.container.append(i.canvas),i.type="PreviewStage",i.mouse=new THREE.Vector2,i.raycaster=new THREE.Raycaster,i.camera.position.set(0,20,600),i.camera.lookAt(new THREE.Vector3(0,0,0)),i.spotLight.position.set(-220,330,550),i.spotLight.castShadow=!D&&!d.isIPad&&n.webglShadow,i.spotLight.shadow&&(i.spotLight.shadow.bias=-8e-4),i.spotLight.intensity=f(n.spotLightIntensity,s.spotLightIntensity),i.ambientLight.color=new THREE.Color(f(n.ambientLightColor,s.ambientLightColor)),i.ambientLight.intensity=f(n.ambientLightIntensity,s.ambientLightIntensity);var o=new THREE.ShadowMaterial;o.opacity=f(n.shadowOpacity,s.shadowOpacity),i.ground.material=o,i.ground.position.z=-2,i.orbitControl.maxAzimuthAngle=0,i.orbitControl.minAzimuthAngle=0,i.orbitControl.minPolarAngle=Math.PI/2,i.orbitControl.maxPolarAngle=2.2,i.orbitControl.mouseButtons.ORBIT=THREE.MOUSE.RIGHT,i.orbitControl.mouseButtons.PAN=-1,i.orbitControl.maxDistance=5e3,i.orbitControl.minDistance=50,i.orbitControl.noZoom=!0,i.selectiveRendering=!0,i.orbitControl.zoomSpeed=5,i.orbitControl.keyPanSpeed=0,i.orbitControl.center.set(0,0,0),i.orbitControl.update(),i.swipe_threshold=D?15:20;var a=i.cssRenderer=new THREE.CSS3DRenderer;t(a.domElement).css({position:"absolute",top:0,pointerEvents:"none"}).addClass("df-3dcanvas df-csscanvas"),i.container[0].appendChild(a.domElement);var r=i.cssScene=new THREE.Scene,l=document.createElement("div");l.className="df-page-content df-page-content-left";var c=document.createElement("div");c.className="df-page-content df-page-content-right";var u=r.divLeft=new THREE.CSS3DObject(l),h=r.divRight=new THREE.CSS3DObject(c);function g(){i.renderRequestPending=!0}r.add(u),r.add(h),i.resizeCallback=function(){a.setSize(i.canvas.width(),i.canvas.height())},window.addEventListener(p.move,g,!1),window.addEventListener("keyup",g,!1),i.dispose=function(){i.clearChild(),i.render(),window.removeEventListener(p.move,g,!1),1==i.options.scrollWheel&&(i.container[0].removeEventListener("mousewheel",m,!1),i.container[0].removeEventListener("DOMMouseScroll",m,!1)),window.removeEventListener("keyup",g,!1),i.renderer.domElement.removeEventListener("mousemove",v,!1),i.renderer.domElement.removeEventListener("touchmove",v,!1),i.renderer.domElement.removeEventListener("mousedown",b,!1),i.renderer.domElement.removeEventListener("touchstart",b,!1),i.renderer.domElement.removeEventListener("mouseup",w,!1),i.renderer.domElement.removeEventListener("touchend",w,!1),i.canvas.remove(),a.domElement.parentNode.removeChild(a.domElement),a=null,i.renderCallback=null,i.renderCallback=null,i.orbitControl.dispose(),i.orbitControl=null,i.renderer.dispose(),i.cancelRAF()},i.renderCallback=function(){TWEEN.getAll().length>0&&(i.renderRequestPending=!0),TWEEN.update(),a.render(r,i.camera)};var m=function(e){if(!0===i.previewObject.options.isLightBox||!0===i.previewObject.ui.isFullscreen){var t=0;if(null!=e.wheelDelta?t=e.wheelDelta:null!=e.detail&&(t=-e.detail),t){var n=i.previewObject.contentProvider.zoomScale;(t>0&&1==n||t<0&&n>1)&&e.preventDefault(),i.previewObject.zoom(t>0?1:-1)}g()}},v=function(e){if(i.renderRequestPending=!0,e=O(e),i.isMouseDown&&0!=e.movementX&&0!=e.movementY&&(i.isMouseMoving=!0),null!=e.touches&&2==e.touches.length&&null!=i.startTouches){i.zoomDirty=!0;var t=d.getVectorAvg(d.getTouches(e,i.container.offset())),n=d.calculateScale(i.startTouches,d.getTouches(e));i.lastScale,i.previewObject.contentProvider.zoomScale,t.x,t.y;return i.camera.position.z=i.originalZ/n,i.lastScale=n,i.lastZoomCenter=t,void e.preventDefault()}if(1==i.isMouseDown&&1==i.previewObject.contentProvider.zoomScale){var o=e.pageX-i.lastPos;performance.now(),i.lastTime;Math.abs(o)>i.swipe_threshold&&(o<0?i.target.next():i.target.prev(),e.preventDefault(),i.isMouseDown=!1),i.lastPos=e.pageX,i.lastTime=performance.now()}},b=function(e){null!=(e=O(e)).touches&&2==e.touches.length&&null==i.startTouches&&(i.startTouches=d.getTouches(e),i.lastScale=1,i.originalZ=1*i.camera.position.z),document.activeElement.blur(),i.mouseValue=e.pageX+","+e.pageY,i.isMouseMoving=!1,i.isMouseDown=!0,i.lastPos=e.pageX,i.lastTime=performance.now()},w=function(e){if(null!=(e=O(e)).touches&&0==e.touches.length){i.previewObject.contentProvider.zoomScale;1==i.zoomDirty&&(i.previewObject.contentProvider.zoomScale=d.limitAt(i.previewObject.contentProvider.zoomScale*i.lastScale,1,i.previewObject.contentProvider.maxZoom),i.previewObject.zoomValue=1*i.previewObject.contentProvider.zoomScale,i.previewObject.resize(),i.zoomDirty=!1),i.lastScale=null,i.startTouches=null}null!=e.touches&&e.touches.length>1||function(e){if(i.isMouseDown=!1,0!==e.button)return this;var n=e.pageX+","+e.pageY;if(i.isMouseMoving);else if(n==i.mouseValue){e=e||window.event,e=t.event.fix(e);var o=i.mouse,a=i.raycaster;o.x=e.offsetX/i.canvas.innerWidth()*2-1,o.y=1-e.offsetY/i.canvas.innerHeight()*2,a.setFromCamera(o,i.camera);var s=a.intersectObjects(i.target instanceof MOCKUP.Bundle?i.target.children:[i.target],!0);if(s.length>0){var r,l=0;do{r=null!=s[l]?s[l].object:null,l++}while((r instanceof THREE.BoxHelper||!(r instanceof MOCKUP.Paper)||1==r.isFlipping)&&l<s.length);null!=r.userData.object||(r.angles[1]>90?1!=r.isEdge&&i.target.next():1!=r.isEdge&&i.target.prev())}}}(e)};return i.renderer.domElement.addEventListener("mousemove",v,!1),i.renderer.domElement.addEventListener("touchmove",v,!1),i.renderer.domElement.addEventListener("mousedown",b,!1),i.renderer.domElement.addEventListener("touchstart",b,!1),i.renderer.domElement.addEventListener("mouseup",w,!1),i.renderer.domElement.addEventListener("touchend",w,!1),1==i.options.scrollWheel&&(i.container[0].addEventListener("mousewheel",m,!1),i.container[0].addEventListener("DOMMouseScroll",m,!1)),t(i.renderer.domElement).css({display:"block"}),t(window).trigger("resize"),this}return _(n,e),n.prototype.width=function(){return this.container.width()},n.prototype.height=function(){return this.container.height()},n}(MOCKUP.Stage),MOCKUP.PreviewStage=j;var n=function(t){function n(e,n){(e=e||{}).folds=1,t.call(this,e,n),this.angle=0,this.isFlipping=!1,this.material.materials[5].transparent=!0,this.material.materials[4].transparent=!0,this.type="BookPaper"}return _(n,t),n.prototype.tween=function(t,n){var i=this,o=1e-5;i.originalStiff=i.stiffness;var a=i.newStiffness,s=F(i.parent),r=n-t,l=t>90,c=i.parent.direction==e.DIRECTION.RTL;i.init={angle:t,angle2:t<90?0:180,stiff:i.originalStiff,index:l&&!c||!l&&c?1:0},i.first={angle:t+r/4,angle2:90,stiff:i.originalStiff,index:l&&!c||!l&&c?1:.25},i.mid={angle:t+2*r/4,angle2:t<90?135:45,stiff:i.newStiffness,index:.5},i.mid2={angle:t+3*r/4,angle2:t<90?180:0,stiff:i.newStiffness,index:l&&!c||!l&&c?.25:1},i.end={angle:n,angle2:t<90?180:0,stiff:i.newStiffness,index:l&&!c||!l&&c?0:1},i.isFlipping=!0;s&&(!l&&!c||l&&c)&&(i.material.materials[5].opacity=i.material.materials[4].opacity=0,i.castShadow=!1),i.currentTween=new TWEEN.Tween(i.init).to({angle:[i.first.angle,i.mid.angle,i.mid2.angle,i.end.angle],angle2:[i.first.angle2,i.mid.angle2,i.mid2.angle2,i.end.angle2],stiff:[i.first.stiff,i.mid.stiff,i.mid2.stiff,i.end.stiff],index:[i.first.index,i.mid.index,i.mid2.index,i.end.index]},i.parent.duration).onUpdate((function(e){var t;t=this,i.angles[1]=t.angle,i.angles[4]=i.isHard?t.angle:t.angle2,1==i.isHard?i.stiffness=0:(i.stiffness=t.stiff/(a+o)*(i.newStiffness+o),i.stiffness=isNaN(i.stiffness)?0:t.stiff),s&&(i.material.materials[5].opacity=i.material.materials[4].opacity=t.index,i.castShadow=t.index>.5),i.updateAngle(!0)})).easing(TWEEN.Easing.Sinusoidal.Out).onComplete((function(e){i.stiffness=i.newStiffness,i.updateAngle(),i.material.materials[5].opacity=i.material.materials[4].opacity=1,i.castShadow=!0,i.isFlipping=!1,i.parent&&i.parent.refresh&&i.parent.refresh()})).start()},n}(MOCKUP.FlexBoxPaper);MOCKUP.BookPaper=n;var i=function(t){function n(n,i){(n=n||{}).segments=n.segments||50,this.pageCount=n.pageCount,this.height=n.height,this.width=n.width,this.direction=n.direction||e.DIRECTION.LTR,this.startPage=1,this.endPage=this.pageCount,this.stackCount=n.stackCount||6,this.materials=[],t.call(this,n,i),this.angles=[0,0,0,0,0,0],this.stiffness=null==n.stiffness?1.5:n.stiffness,this.hardConfig=n.hard,this._activePage=n.openPage||this.startPage,this.createStack(n),this.pageMode=n.pageMode||(D||this.pageCount<=2?e.PAGE_MODE.SINGLE:e.PAGE_MODE.DOUBLE),this.singlePageMode=n.singlePageMode||(D?e.SINGLE_PAGE_MODE.BOOKLET:e.SINGLE_PAGE_MODE.ZOOM),this.type="Book"}return _(n,t),n.prototype.getPageByNumber=function(e){var t=F(this)?M(this)?e+1:e:Math.floor((e-1)/2);return this.getObjectByName(t.toString())},n.prototype.isPageHard=function(e){return d.isHardPage(this.hardConfig,e,this.pageCount)},n.prototype.activePage=function(e){if(null==e)return this._activePage;this.gotoPage(e)},n.prototype.gotoPage=function(e){e=parseInt(e,10),this._activePage=e,1==this.autoPlay&&this.previewObject.setAutoPlay(this.autoPlay),this.updatePage(e),this&&this.thumblist&&this.thumblist.review&&this.thumblist.review()},n.prototype.moveBy=function(e){var t=this._activePage+e;t=x(t,this.startPage,this.endPage),1!=this.firstFlipped&&(this.previewObject.analytics({eventAction:"First Page Flip",options:this.previewObject.options}),this.firstFlipped=!0),this.gotoPage(t)},n.prototype.next=function(t){null==t&&(t=this.direction==e.DIRECTION.RTL?-this.pageMode:this.pageMode),this.moveBy(t)},n.prototype.prev=function(t){null==t&&(t=this.direction==e.DIRECTION.RTL?this.pageMode:-this.pageMode),this.moveBy(t)},n.prototype.updateAngle=function(){for(var e=this.angles[1],t=this.angles[4]-e,n=this.stackCount,i=0;i<n;i++){var o=this.children[i];o.angles[1]=e+i*t/(100*n),o.stiffness=this.stiffness,o.updateAngle()}},n.prototype.refresh=function(){this.updatePage(this._activePage),null!=this.flipCallback&&this.flipCallback()},n.prototype.updatePage=function(t){var n=this.direction==e.DIRECTION.RTL,i=F(this),o=(k(t),i?1:2);t=Math.floor(t/o),n&&(t=Math.ceil(this.pageCount/o)-t);var a=this.oldBaseNumber||0,r=this.pageCount/o,l=this.stackCount,c=.02,d=.4,u=i?0:(.5-Math.abs(r/2-t)/r)/this.stiffness,h=Math.floor(l/2),p=!1;a>t?(p=!0,this.children[l-1].skipFlip=!0,this.children.unshift(this.children.pop())):a<t&&(this.children[0].skipFlip=!0,this.children.push(this.children.shift()));for(var g=5/r,f=g*t/2,m=g*(r-t)/2,v=f<m?m:f,b=0;b<l;b++){var w,P=this.children[b],x=(P.color,P.angles[1]),y=t-h+b;n&&(y=i?this.pageCount-y:Math.ceil(this.pageCount/2)-y-1);var C=P.isHard=this.isPageHard(y),L=P.name;P.isEdge=!1,0==b?P.depth=f<d?d:f:b==l-1?P.depth=m<d?d:m:(P.depth=d,P.isEdge=!1),1==P.isFlipping&&(P.depth=d),P.position.x=0;var S=c*b,I=180-c*(b-h)+c*b;if(b<h?(P.newStiffness=C||0==this.stiffness?0:u/(t/r)/4,w=S,P.position.z=v-(-b+h)*d,1==p&&(P.position.z-=d)):(w=I,P.newStiffness=C||0==this.stiffness?0:u/(Math.abs(r-t)/r)/4,P.position.z=v-(-l+b+h+1)*d-P.depth),0==P.isFlipping)if(Math.abs(x-w)>20&&0==P.skipFlip){P.depth=d;var E=P.stiffness;E=x>w?u/(Math.abs(r-t)/r)/4:u/(t/r)/4,P.position.z+=d,P.stiffness=isNaN(E)?P.stiffness:E,P.updateAngle(!0),P.targetStiffness=C?0:b<t?u/(Math.abs(r-t)/r)/4:u/(t/r)/4,P.targetStiffness=C?0:isNaN(P.targetStiffness)?P.stiffness:P.targetStiffness,P.isFlipping=!0,P.tween(x,w),null!=this.preFlipCallback&&this.preFlipCallback()}else P.skipFlip=!1,P.newStiffness=isNaN(P.newStiffness)?0:P.newStiffness,P.angles[1]==w&&P.stiffness==P.newStiffness&&P.depth==P.oldDepth||(P.angles[1]=P.angles[4]=w,P.stiffness=P.newStiffness,P.updateAngle(!0));P.visible=i?n?b<h||P.isFlipping:b>=h||P.isFlipping:y>=0&&y<r||i&&y==r,null!=this.requestPage&&(P.name=y.toString(),P.name!=L&&(P.textureLoaded=!1,P.frontImage(s.textureLoadFallback),P.frontPageStamp="-1",P.frontTextureLoaded=!1,P.thumbLoaded=!1,P.backImage(s.textureLoadFallback),P.backPageStamp="-1",P.backTextureLoaded=!1,this.requestPage())),P.oldDepth=P.depth;var T=Math.abs(P.geometry.boundingBox.max.x)<Math.abs(P.geometry.boundingBox.min.x)?P.geometry.boundingBox.max.x:P.geometry.boundingBox.min.x;P.position.x=1==P.isEdge&&0==P.isFlipping?b<h?T:-T:0}this.oldBaseNumber=t,null!=this.updatePageCallback&&this.updatePageCallback()},n.prototype.createCover=function(e){e.width=2*e.width,this.cover=new MOCKUP.BiFold(e),this.add(this.cover)},n.prototype.createStack=function(e){for(var t="red,green,blue,yellow,orange,black".split(","),n=0;n<this.stackCount;n++){e.angles=[,this.stackCount-n],e.stiffness=(this.stackCount-n)/100;var i=new MOCKUP.BookPaper(e);i.angles[1]=180,i.index=n,i.updateAngle(),i.textureReady=!1,i.textureRequested=!1,this.add(i),i.color=t[n],i.position.z=-1*n}},n.prototype.shininess=function(e){if(null==e)return this.mainObject.shininess();this.mainObject.shininess(e)},n.prototype.bumpScale=function(e){if(null==e)return this.mainObject.bumpScale();this.mainObject.bumpScale(e)},n.prototype.frontImage=function(e){if(null==e)return this.mainObject.frontImage();this.mainObject.frontImage(e)},n.prototype.backImage=function(e){if(null==e)return this.mainObject.backImage();this.mainObject.backImage(e)},n}(MOCKUP.Bundle);MOCKUP.Book=i}var H=function(n){function i(t){t=t||{},this.type="PreviewObject";var n=this;function i(){setTimeout((function(){n.resize()}),50)}n.zoomValue=1,window.addEventListener("resize",i,!1),this.sound=document.createElement("audio"),this.sound.setAttribute("src",t.soundFile+"?ver="+e.version),this.sound.setAttribute("type","audio/mpeg"),this.autoPlayFunction=function(){n&&n.target.autoPlay&&(n.target.direction==e.DIRECTION.RTL?n.target.prev():n.target.next())},this.dispose=function(){if(clearInterval(this.autoPlayTimer),this.autoPlayTimer=null,this.autoPlayFunction=null,this.target&&this.target.children)for(var e=0;e<this.target.children.length;e++){var t=this.target.children[e];t&&t.currentTween&&t.currentTween.stop()}this.zoomTween&&(this.zoomTween.stop&&this.zoomTween.stop(),this.zoomTween=null),this.container&&(this.container.removeClass&&this.container.removeClass("df-sidemenu-open df-floating"),this.container.info&&this.container.info.remove&&this.container.info.remove(),this.commentPopup.remove()),this.target&&this.target.dispose&&this.target.dispose(),this.target=null,this.stage&&this.stage.dispose&&this.stage.dispose(),this.stage=null,this.ui&&this.ui.dispose&&this.ui.dispose(),this.ui=null,this.contentProvider&&this.contentProvider.dispose&&this.contentProvider.dispose(),this.contentProvider=null,this.checkRequestQueue=null,window.removeEventListener("resize",i)},this.checkRequestQueue()}return i.prototype={checkRequestQueue:function(){var e=this;e.checkRequestQueue&&window.requestAnimationFrame&&requestAnimationFrame((function(){e&&e.checkRequestQueue&&e.checkRequestQueue()})),e.container&&e.container[0]&&e._offsetParent!==e.container[0].offsetParent&&(e._offsetParent=e.container[0].offsetParent,null!==e._offsetParent&&e.resize(),d.log("Visibility Resize Detected"))},start:function(){this.target.gotoPage(this.target.startPage)},end:function(){this.target.gotoPage(this.target.endPage)},next:function(){},prev:function(){},getPageTextContent:function(e){return this.contentProvider.pdfDocument.getPage(e+1).then((function(e){return e.getTextContent({normalizeWhitespace:!0})}))},calculateSize:function(e,t,n,i,o,a,s,r){var l=e,c=t-o,d=l-i,u=Math.ceil(r?c:c/2),h=u/s,p=null;a?l=p=Math.min(h,n-i):p=Math.min(d,n-i);var g,f,m=h>p;return m?(f=p,g=Math.floor(f*s)):(g=u,f=Math.ceil(u/s)),a&&(l=Math.max(f+i,320)),{stageHeight:l,isWide:m,height:f,width:g}},zoom:function(e){this.pendingZoom=!0,this.zoomDelta=e,this.resize(),this.ui&&this.ui.update()},resize:function(){var n=this;if(null!=n.target&&null!=n.target.ui&&null!=n.target.contentProvider&&null!=n.target.contentProvider.viewport&&null!=n.target.stage){this.ui&&1==this.ui.isFullscreen&&1==d.hasFullscreenEnabled()&&null==d.getFullscreenElement()&&this.ui.switchFullscreen();var i,o,a,s,r,l,c=n.target,h=n.container,p=n.options,g=c.stage,f=c.contentProvider,m=f.pageRatio,v=(f.zoomViewport,M(c)),b="css"!==c.mode,w=(f.pageRatio,1!=this.ui.isFullscreen&&"auto"===p.height),P=h.hasClass("df-sidemenu-open")?220:0,C=this.target.pageMode==e.PAGE_MODE.SINGLE;void 0===this._offsetParent&&(this._offsetParent=this.container[0].offsetParent);var L=h.width();L<400?n.container.addClass("df-xs"):n.container.removeClass("df-xs");var S=h.find(".df-ui-controls").height(),I=p.paddingTop+(p.controlsPosition==e.CONTROLSPOSITION.TOP?S:0),E=p.paddingRight,k=p.paddingBottom+(p.controlsPosition==e.CONTROLSPOSITION.BOTTOM?S:0),T=p.paddingLeft,O=(I=isNaN(I)?0:x(I,0,I))+(k=isNaN(k)?0:x(k,0,k)),R=(T=isNaN(T)?0:x(T,0,T))+(E=isNaN(E)?0:x(E,0,E)),F=L-P;h.height(p.height);var D=t(window).height(),N=Math.min(h.height(),D),z=n.calculateSize(N,F,D,O,R,w,m,C);N=B=w?n.calculateSize(N,F+P,D,O,R,w,m,C).stageHeight:z.stageHeight,h.height(N);var B=N,_=F-R,A=B-O;if(a=Math.floor(C?_:_/2),(i=(o=Math.floor(a/m))>A)&&(a=(o=A)*m),l=f.maxZoom=f.zoomViewport.height/o,null==n.zoomValue&&(n.zoomValue=1),null==f.zoomScale&&(f.zoomScale=1),1==n.pendingZoom&&null!=n.zoomDelta){n.zoomDelta,Math.max(o,a);n.zoomValue=n.zoomDelta>0?n.zoomValue*n.options.zoomRatio:n.zoomValue/n.options.zoomRatio,n.zoomValue=x(n.zoomValue,1,l),1==n.zoomValue?f.zoomScale=1:f.zoomScale=x(n.zoomValue,1,l)}r=f.zoomScale,f.checkViewportSize(a,o,r),f.contentSourceType==u.PDF&&(a=f.imageViewport.width/r,o=f.imageViewport.height/r),1!=f.zoomScale&&this.target.container.addClass("df-zoom-enabled");var j=c.zoomWidth=Math.floor(a*r),U=c.zoomHeight=Math.floor(o*r),H=2*j;if(b){var W=U/c.height,V=i?r*(o+O)/W:r*(a*(C?1:2)+R)/W/(F/B);g.resizeCanvas(F,B),s=1/(2*Math.tan(Math.PI*g.camera.fov*.5/180)/(V/r))+2.2,g.camera.updateProjectionMatrix(),g.renderRequestPending=!0;var G=(I-k)*(c.height/o)/r/2,q=1==f.zoomScale;g.camera.position.z!==s&&1==n.pendingZoom?(null!=n.zoomTween&&n.zoomTween.stop(),n.zoomTween=new TWEEN.Tween({campos:g.camera.position.z,otx:g.orbitControl.target.x,oty:g.orbitControl.target.y,otz:g.orbitControl.target.z}).delay(0).to({campos:s,otx:0,oty:G,otz:0},100).onUpdate((function(){g.camera.position.z=this.campos,q&&(g.camera.position.y=this.oty,g.orbitControl.target=new THREE.Vector3(this.otx,this.oty,this.otz)),g.orbitControl.update()})).easing(TWEEN.Easing.Linear.None).onComplete((function(){g.camera.position.z=s,1==f.zoomScale&&(g.camera.position.set(0,G,s),g.orbitControl.target=new THREE.Vector3(0,G,0)),g.orbitControl.update()})).start()):(1==f.zoomScale&&(g.camera.position.set(0,G,s),g.orbitControl.target=new THREE.Vector3(0,G,0)),g.orbitControl.update()),g.orbitControl.update(),g.orbitControl.mouseButtons.ORBIT=1!=r?-1:THREE.MOUSE.RIGHT,g.orbitControl.mouseButtons.PAN=1!=r?THREE.MOUSE.LEFT:-1}else{c.pageWidth=Math.round(a),c.fullWidth=2*c.pageWidth,c.height=Math.round(o);var Z=c.shiftHeight=Math.round(x((U-B+O)/2,0,U)),Y=c.shiftWidth=Math.round(x((H-F+R)/2,0,H));1==r&&(c.left=0,c.top=0),c.stage.css({top:-Z,bottom:-Z,right:-Y+(v?P:0),left:-Y+(v?0:P),paddingTop:I,paddingRight:E,paddingBottom:k,paddingLeft:T,transform:"translate3d("+c.left+"px,"+c.top+"px,0)"}),c.stageHeight=g.height(),c.wrapper.css({width:H,height:U,marginTop:N-U-O>0?(N-O-U)/2:0});var K=Math.floor(y(a,o)*r);c.stage.find(".df-page-wrapper").width(K).height(K),c.stage.find(".df-book-page, .df-page-front , .df-page-back, .df-page-fold-inner-shadow").height(U).width(j)}n.checkCenter({type:"resize"}),1==f.zoomScale&&this.target.container.removeClass("df-zoom-enabled"),c.thumblist&&c.thumblist.reset(t(c.thumblist.container).height()),n.pendingZoom=!1}},playSound:function(){try{this.options&&1==this.options.soundEnable&&(this.sound.currentTime=0,this.sound.play())}catch(e){}},setPageMode:function(t){1==t?(this.ui.pageMode.addClass(this.options.icons.doublepage),this.ui.pageMode.html("<span>"+this.options.text.doublePageMode+"</span>"),this.ui.pageMode.attr("title",this.options.text.doublePageMode),this.target.pageMode=e.PAGE_MODE.SINGLE):(this.ui.pageMode.removeClass(this.options.icons.doublepage),this.ui.pageMode.html("<span>"+this.options.text.singlePageMode+"</span>"),this.ui.pageMode.attr("title",this.options.text.singlePageMode),this.target.pageMode=e.PAGE_MODE.DOUBLE),this.target&&this.target.singlePageMode==e.SINGLE_PAGE_MODE.BOOKLET&&this.target.reset(),this.resize()},setAutoPlay:function(e){if(this.options.autoPlay){var t=(e=1==e)?this.options.text.pause:this.options.text.play;this.ui.play.toggleClass(this.options.icons.pause,e),this.ui.play.html("<span>"+t+"</span>"),this.ui.play.attr("title",t),clearInterval(this.autoPlayTimer),e&&(this.autoPlayTimer=setInterval(this.autoPlayFunction,this.options.autoPlayDuration)),this.target.autoPlay=e}},height:function(e){if(null==e)return this.container.height();this.options.height=e,this.container.height(e),this.resize()},checkCenter:function(t){t=null==t?{}:t,this.centerType=this.centerType||"start";var n,i=this.target,o=0,a=0,s=0,r=d.getBasePage(i._activePage),l=i._activePage%2==0,c=i.direction==e.DIRECTION.RTL,u=i.pageMode==e.PAGE_MODE.SINGLE,h=u&&i.singlePageMode==e.SINGLE_PAGE_MODE.BOOKLET,p=i.stage.width();if("css"==i.mode)n=i.wrapper.width(),o=Math.max((n-p)/2,0),a=-n/4,s=n/4,0==r||h?(i.wrapper.css({left:u?c?s-o:a-o:c?s:a}),i.shadow.css({width:"50%",left:c?0:"50%",transitionDelay:""})):r==i.pageCount?(i.wrapper.css({left:u?c?a-o:s-o:c?a:s}),i.shadow.css({width:"50%",left:c?"50%":0,transitionDelay:""})):(i.wrapper.css({left:u?c?l?a-o:s-o:l?s-o:a-o:0}),i.shadow.css({width:"100%",left:0,transitionDelay:parseInt(i.duration,10)+50+"ms"})),i.wrapper.css({transition:"resize"==t.type?"none":""});else if(null!=i.stage){var g,f=i.position.x;o=i.width/4,a=-(n=i.width)/2,s=n/2,(g=0==r||h?c?s:a:r==i.pageCount?c?a:s:u?c?l?a:s:l?s:a:0)!==this.centerEnd&&(this.centerTween=new TWEEN.Tween({x:f}).delay(0).to({x:g},i.duration).onUpdate((function(){i.position.x=this.x,i.stage.cssScene.position.x=this.x})).easing(i.ease).start(),this.centerEnd=g)}},width:function(e){if(null==e)return this.container.width();this.options.width=e,this.container.width(e),this.resize()}},i}();e.PreviewObject=H;var W=function(n){function i(n,i,o,a){o=o||{};var r=this;if(r.contentRawSource=n||[s.textureLoadFallback],r.contentSource=r.contentRawSource,r.contentSourceType=null,r.minDimension=o.minTextureSize||256,r.maxDimension=o.maxTextureSize||2048,r.pdfRenderQuality=o.pdfRenderQuality||e.defaults.pdfRenderQuality,r.flipbook=a,r.waitPeriod=50,r.maxLength=297,r.enableDebug=!1,r.zoomScale=1,r.maxZoom=2,r.options=o,r.outline=o.outline,r.links=o.links,r.html=o.html,r.isCrossOrigin=o.isCrossOrigin,r.normalViewport={height:297,width:210,scale:1},r.viewport={height:297,width:210,scale:1},r.imageViewport={height:297,width:210,scale:1},r.bookSize={height:297,width:210},r.zoomViewport={height:297,width:210},r.thumbsize=128,r.cacheIndex=256,r.cache=[],r.pageRatio=o.pageRatio||r.viewport.width/r.viewport.height,r.textureLoadTimeOut=null,r.type="TextureLibrary",Array===r.contentSource.constructor||Array.isArray(r.contentSource)||r.contentSource instanceof Array){r.contentSourceType=u.IMAGE,r.pageCount=r.contentSource.length;for(var l=0;l<r.contentSource.length;l++)r.contentSource[l]=d.httpsCorrection(r.contentSource[l].toString());t("<img/>").attr("src",r.contentSource[0]).on("load",(function(){r.viewport.height=this.height,r.viewport.width=this.width,r.pageRatio=r.viewport.width/r.viewport.height,r.bookSize={width:(r.pageRatio>1?1:r.pageRatio)*r.maxLength,height:r.maxLength/(r.pageRatio<1?1:r.pageRatio)},r.zoomViewport={width:(r.pageRatio>1?1:r.pageRatio)*r.maxDimension,height:r.maxDimension/(r.pageRatio<1?1:r.pageRatio)},r.linkService=new PDFLinkService,t(this).off(),r.options.pageSize==e.PAGE_SIZE.DOUBLEINTERNAL&&(r.pageCount=2*r.contentSource.length-2,1==r.options.webgl&&(r.requiresImageTextureScaling=!0)),null!=i&&(i(r),i=null),S(this.height+":"+this.width)}))}else if("string"==typeof r.contentSource||r.contentSource instanceof String){var c=function(){r.contentSource.indexOf(".base64")>1?t.ajax({url:r.contentSource,xhrFields:{onprogress:function(e){if(e.lengthComputable){var t=100*e.loaded/e.total;r.updateInfo(r.options.text.loading+" PDF "+t.toString().split(".")[0]+"% ...")}}},success:function(e){r.options.docParameters={data:atob(e)},h()}}):h()},h=function(){if(r){pdfjsLib.GlobalWorkerOptions.workerSrc=s.pdfjsWorkerSrc,r.contentSourceType=u.PDF;var t=r.options.disableFontFace;z||B||r.options.disableFontFace;var o=r.loading=pdfjsLib.getDocument(r.options.docParameters?r.options.docParameters:{url:d.httpsCorrection(n),rangeChunkSize:isNaN(r.options.rangeChunkSize)?524288:r.options.rangeChunkSize,cMapUrl:s.cMapUrl,cMapPacked:!0,imageResourcesPath:s.imageResourcesPath,disableAutoFetch:!0,disableStream:!0,disableRange:!0===r.options.disableRange,disableFontFace:t});o.promise.then((function(t){r.pdfDocument=t,t.getPage(1).then((function(n){r.normalViewport=n.getViewport({scale:1}),r.viewport=n.getViewport({scale:1}),r.viewport.height=r.viewport.height/10,r.viewport.width=r.viewport.width/10,r.pageRatio=r.viewport.width/r.viewport.height,r.bookSize={width:(r.pageRatio>1?1:r.pageRatio)*r.maxLength,height:r.maxLength/(r.pageRatio<1?1:r.pageRatio)},r.zoomViewport={width:(r.pageRatio>1?1:r.pageRatio)*r.maxDimension,height:r.maxDimension/(r.pageRatio<1?1:r.pageRatio)},r.refPage=n,t.numPages>1?t.getPage(2).then((function(n){if(r.options.pageSize==e.PAGE_SIZE.AUTO){var o=n.getViewport({scale:1});o.width/o.height>1.5*r.pageRatio?(r.options.pageSize=e.PAGE_SIZE.DOUBLEINTERNAL,r.pageCount=2*t.numPages-2):r.options.pageSize=e.PAGE_SIZE.SINGLE}null!=i&&(i(r),i=null)})):null!=i&&(i(r),i=null)})),r.linkService=new PDFLinkService,r.linkService.setDocument(t,null),r.pageCount=t.numPages,r.contentSource=t}),(function(e){if(r){var t="",n=document.createElement("a");n.href=r.contentSource,n.hostname!==window.location.hostname&&(t="CROSS ORIGIN!! "),r.updateInfo(t+"Cannot access file!  "+r.contentSource)}})),o.onProgress=function(e){if(r){var t=100*e.loaded/e.total;isNaN(t)?e&&e.loaded?r.updateInfo(r.options.text.loading+" PDF "+(Math.ceil(e.loaded/1e4)/100).toString()+"MB ..."):r.updateInfo(r.options.text.loading+" PDF ..."):r.updateInfo(r.options.text.loading+" PDF "+t.toString().split(".")[0]+"% ...")}}}},p=function(){if(r){s.pdfjsWorkerSrc.indexOf("?ver")<0&&(s.pdfjsWorkerSrc+="?ver="+e.version),r.updateInfo(r.options.text.loading+" PDF Worker ...");var n=document.createElement("a");n.href=s.pdfjsWorkerSrc,n.hostname!==window.location.hostname?(r.updateInfo(r.options.text.loading+" PDF Worker CORS ..."),t.ajax({url:s.pdfjsWorkerSrc,cache:!0,success:function(t){s.pdfjsWorkerSrc=e.createObjectURL(t,"text/javascript"),c()}})):c()}};null==window.pdfjsLib?r&&(r.updateInfo(r.options.text.loading+" PDF Service ..."),T(s.pdfjsSrc+"?ver="+e.version,(function(){"function"==typeof define&&define.amd&&window.requirejs?(r.updateInfo(r.options.text.loading+" PDF Service (require) ..."),require.config({paths:{"pdfjs-dist/build/pdf.worker":s.pdfjsWorkerSrc.replace(".js","")}}),require(["pdfjs-dist/build/pdf"],(function(e){window.pdfjsLib=e,p()}))):"object"==typeof exports&&null!=exports["pdfjs-dist/build/pdf"]?(window.pdfjsLib=exports["pdfjs-dist/build/pdf"],p()):p()}),(function(){r.updateInfo("Unable to load PDF service..")}))):c()}else console.error("Unknown source type. Please check documentation for help");return this.dispose=function(){r.loading&&r.loading.destroy&&r.loading.destroy(),r.loading=null,r.textureLoadTimeOut&&(clearTimeout(r.textureLoadTimeOut),r.textureLoadTimeOut=null),this.targetObject&&(this.targetObject.thumbContainer&&this.targetObject.thumbContainer.remove&&this.targetObject.thumbContainer.remove(),this.targetObject.outlineContainer&&this.targetObject.outlineContainer.remove&&this.targetObject.outlineContainer.remove(),this.targetObject.dispose&&this.targetObject.dispose(),this.targetObject.processPage=null,this.targetObject.requestPage=null,this.targetObject.container&&this.targetObject.container.off&&this.targetObject.container.off()),this.pdfDocument&&this.pdfDocument.destroy&&this.pdfDocument.destroy(),this.linkService&&this.linkService.dispose&&this.linkService.dispose(),this.outlineViewer&&this.outlineViewer.dispose&&this.outlineViewer.dispose(),this.thumblist&&this.thumblist.dispose&&(this.thumblist.review=null,this.thumblist.dispose()),this.activeThumb=null,this.targetObject=null,this.pdfDocument=null,this.linkService=null,this.outlineViewer=null,this.thumblist=null,r=null},this}return _(i,{}),i.prototype.updateInfo=function(e){this.flipbook&&this.flipbook.updateInfo&&this.flipbook.updateInfo(e)},i.prototype.initThumbs=function(){var e,n=this;null==n.cache[n.thumbsize]&&(n.cache[n.thumbsize]=[]);var i=function(){clearTimeout(e),e=setTimeout((function(){e=setTimeout(o,n.waitPeriod/2)}),n.waitPeriod)},o=function(){var o=0;if((Date.now()-n.thumblist.lastScrolled<100?o=1:(n.targetObject.container.find(".df-thumb-container .df-vrow").each((function(){var e=t(this);if(!e.hasClass("df-thumb-loaded")){o++;var a=t(this).attr("id").replace("df-thumb","");return n.getPage(a,i,!0),e.addClass("df-thumb-loaded"),!1}})),0==o&&clearTimeout(e)),o>0&&i(),n.activeThumb!=n.targetObject._activePage)&&(null!=n.targetObject.thumbContainer&&n.targetObject.thumbContainer.hasClass("df-sidemenu-visible"))){var a=n.thumblist.container,s=a.scrollTop,r=a.getBoundingClientRect().height,l=n.targetObject.thumbContainer.find("#df-thumb"+n.targetObject._activePage);l.length>0?(n.targetObject.thumbContainer.find(".df-selected").removeClass("df-selected"),l.addClass("df-selected"),s+r<(l=l[0]).offsetTop+l.scrollHeight?d.scrollIntoView(l,null,!1):s>l.offsetTop&&d.scrollIntoView(l),n.activeThumb=n.targetObject._activePage):(t(a).scrollTop(124*n.targetObject._activePage),i())}};n.thumblist=n.targetObject.thumblist=new ThumbList({h:500,addFn:function(e){},scrollFn:i,itemHeight:128,totalRows:n.pageCount,generatorFn:function(e){var t=document.createElement("div"),n=e+1;t.id="df-thumb"+n;var i=document.createElement("div");return i.innerHTML=n,t.appendChild(i),t}}),n.thumblist.lastScrolled=Date.now(),n.thumblist.review=i,i();var a=t("<div>").addClass("df-thumb-container df-sidemenu-visible df-sidemenu");a.append(t(n.thumblist.container).addClass("df-thumb-wrapper")),n.targetObject.thumbContainer=a,n.targetObject.container.append(a);var s=t(g.div,{class:"df-ui-btn df-ui-sidemenu-close ti-close"});a.append(s),n.thumblist.reset(t(n.thumblist.container).height()),n.targetObject.container.on("click",".df-thumb-container .df-vrow",(function(e){e.stopPropagation();var i=t(this).attr("id").replace("df-thumb","");n.targetObject.gotoPage(parseInt(i,10))}))},i.prototype.initOutline=function(){var e=this,n=t("<div>").addClass("df-outline-container df-sidemenu"),i=t("<div>").addClass("df-outline-wrapper"),o=t(g.div,{class:"df-ui-btn df-ui-sidemenu-close ti-close"});function a(t){if(1==e.options.overwritePDFOutline&&(t=[]),t=t||[],e.outline)for(var n=0;n<e.outline.length;n++)e.outline[n].custom=!0,t&&t.push(e.outline[n]);0===t.length&&null!=e.targetObject.ui.outline?e.targetObject.ui.outline.hide():1==e.options.autoEnableOutline&&e.targetObject.ui.outline.trigger("click"),e.outlineViewer.render({outline:t})}n.append(o).append(i),e.targetObject.container.append(n),e.targetObject.outlineContainer=n,e.outlineViewer=new BookMarkViewer({container:i[0],linkService:e.linkService,outlineItemClass:"df-outline-item",outlineToggleClass:"df-outline-toggle",outlineToggleHiddenClass:"df-outlines-hidden"}),e.pdfDocument?e.pdfDocument.getOutline().then((function(e){a(e)})):a([]),1==e.options.autoEnableThumbnail&&e.targetObject.ui.thumbnail.trigger("click")},i.prototype.checkViewportSize=function(e,t,n){var i=this,o=i.targetObject,a=e*n,r=t*n,l=i.cacheIndex;if(i.contentSourceType==u.PDF){if(i.cacheIndex=Math.ceil(Math.max(a,r)),i.cacheIndex=Math.floor(Math.max(a,r)),i.cacheIndex=x(i.cacheIndex*s.pixelRatio,i.minDimension,i.maxDimension),null==i.cache[i.cacheIndex]&&(i.cache[i.cacheIndex]=[]),l!==i.cacheIndex){for(var c=0;c<o.children.length;c++)o.children[c];o.refresh()}i.imageViewport=i.refPage.getViewport({scale:r/i.normalViewport.height}),i.viewport="css"==o.mode?i.imageViewport:i.refPage.getViewport({scale:i.bookSize.height/i.normalViewport.height}),S(i.cacheIndex),i.annotedPage=void 0,i.review()}else null==i.cache[i.cacheIndex]&&(i.cache[i.cacheIndex]=[])},i.prototype.getCache=function(e,t){return 1==t?null==this.cache[this.thumbsize]?null:this.cache[this.thumbsize][e]:null==this.cache[this.cacheIndex]?null:this.cache[this.cacheIndex][e]},i.prototype.setCache=function(e,t,n,i){if(1==n)null!=this.cache[this.thumbsize]&&(this.cache[this.thumbsize][e]=t);else{var o=null==i?this.cacheIndex:i;null!=this.cache[o]&&(this.cache[o][e]=t)}},i.prototype.setTarget=function(e){var t=this;if(null==e)return this.targetObject;this.targetObject=e,e.contentProvider=this,e.container.removeClass("df-loading df-init"),null!=t.linkService&&(t.linkService.setViewer(e),t.initOutline()),e.processPage=function(e,n){e>0&&e<=t.pageCount?t.getPage(e,n):t.setPage(e,s.textureLoadFallback,n)},e.requestPage=function(){t.review("Request")},null!=e.resize&&e.resize()},i.prototype.review=function(e){var t=this;e=e||"timer review",clearTimeout(t.textureLoadTimeOut),t.textureLoadTimeOut=setTimeout((function(){t.textureLoadTimeOut=setTimeout(t.reviewPages,t.waitPeriod/2,t,e)}),t.waitPeriod)},i.prototype.reviewPages=function(e,n){var i=(e=e||this).targetObject;if(null!=i){var o=F(i);null!=n&&S(n);var a,s=!1;for(a=0;a<e.targetObject.children.length;a++)if(1==i.children[a].isFlipping){s=!0;break}if(0==s){var r=i.children.length>3?3:i.children.length,l=o?i._activePage:k(i._activePage);for(e.baseNumber=l,e.zoomScale>1&&(r=1),a=0;a<r;a++){var c=Math.floor(a/2),d=a%2==0?-c*(o?1:2):(0==c?1:c)*(o?1:2),u=l+d,h=l+d+1,p=i.getPageByNumber(u),g=i.getPageByNumber(h),f=u+"|"+e.cacheIndex,m=h+"|"+e.cacheIndex,v=0;if(null!=p&&p.frontPageStamp!=f&&1==p.visible&&(p.frontTextureLoaded=!1,i.processPage(u,(function(){e.review("Batch Call")})),p.frontPageStamp=f,v++),null==g||g.backPageStamp==m||1!=g.visible||o||(g.backTextureLoaded=!1,i.processPage(h,(function(){e.review("Batch Call")})),g.backPageStamp=m,v++),0==d&&e.annotedPage!==l&&(e.getAnnotations(u),o||e.getAnnotations(h),e.annotedPage=l),v>0)break}0==v&&"css"!==i.mode&&e.setLoading(l)}else if(e.review("Revisit request"),null!=e.annotedPage&&"css"!==i.mode){var b=k(i._activePage);t(i.getContentLayer(b)).html(""),t(i.getContentLayer(b+1)).html(""),e.annotedPage=null}}},i.prototype.getPage=function(n,i,o){var a=this,r=n=parseInt(n,10),l=a.contentSource;n<=0&&n>=a.pageCount?a.setPage(n,s.textureLoadFallback,i,o):a.contentSourceType==u.PDF?null!=a.getCache(n,o)?(a.setPage(n,a.getCache(n,o),i,o),S("Page "+n+" loaded from cache")):(!0!==o&&a.setLoading(n,!0),a.options.pageSize==e.PAGE_SIZE.DOUBLEINTERNAL&&n>2&&(r=Math.ceil((n-1)/2)+1),l.getPage(r,o).then((function(t){!function(t,n,i,o){var s=a.options.forceFit,r=a.options.pageSize==e.PAGE_SIZE.DOUBLEINTERNAL&&n>1&&n<a.pageCount,l=r&&s?2:1,c=s?t.getViewport({scale:1}):a.normalViewport,d=a.cacheIndex/Math.max(c.width/l,c.height);1==a.webgl&&(d=I(a.cacheIndex)/(a.pageRatio>1?c.width/l:c.height));var u=document.createElement("canvas"),h=performance.now(),p=a.cacheIndex,g=u.getContext("2d");1==o&&(d=a.thumbsize/a.normalViewport.height);u.height=Math.round(c.height*d),u.width=Math.round(c.width/l*d),"css"==a.targetObject.mode&&Math.abs(a.targetObject.zoomHeight-u.height)<2&&Math.abs(a.targetObject.zoomWidth-u.width)<2&&(u.height=a.targetObject.zoomHeight+0,u.width=a.targetObject.zoomWidth+0);c=t.getViewport({scale:d}),S("rendering "+n+" at "+u.width+"x"+u.height),r&&(M(a.targetObject)?n%2==0&&(c.transform[4]=-u.width):n%2==1&&(c.transform[4]=-u.width));var f={canvasContext:g,viewport:c};t.cleanupAfterRender=!0,t.render(f).promise.then((function(){S(performance.now()-h),h=performance.now(),1==o||1==a.options.canvasToBlob&&!0!==a.webgl?u.toBlob((function(t){var s=e.createObjectURL(t,"image/jpeg");S(performance.now()-h),a.setCache(n,s,o,p),a.setPage(n,s,i,o)}),"image/jpeg",a.pdfRenderQuality):(S("Setting Page "+n),a.setPage(n,u,i,o)),f=null}))}(t,n,i,o)}))):a.contentSourceType!=u.IMAGE&&a.contentSourceType!=u.HTML||(null!=a.getCache(n,o)?(a.setPage(n,a.getCache(n,o),i,o),S("Page "+n+" loaded from cache")):(!0!==o&&a.setLoading(n,!0),a.options.pageSize==e.PAGE_SIZE.DOUBLEINTERNAL&&n>2&&(r=Math.ceil((n-1)/2)+1),function(e,n,i){t("<img/>").attr("src",e).on("load",(function(){t(this).off(),null!=n&&n(e),S(this.height+":"+this.width)}))}(l[r-1],(function(e){a.setCache(n,e,o,a.cacheIndex),a.setPage(n,e,i,o),null!=i&&i()}),a.isCrossOrigin)))},i.prototype.getTargetPage=function(e){},i.prototype.setLoading=function(e,n){if(null!=this.targetObject)if(1==this.webgl){var i=this.targetObject.container;1==n?!0!==i.isLoading&&(i.addClass("df-loading"),i.isLoading=!0,S("Loading icon at "+e+" as "+n)):null!=i.isLoading&&(i.removeClass("df-loading"),i.isLoading=null,S("Loading icon at "+e+" as "+n))}else{var o=t(this.targetObject.getContentLayer(e));null!=o&&(1==n?o.addClass("df-page-loading"):o.removeClass("df-page-loading"),S("Loading icon at "+e+" as "+n))}},i.prototype.getAnnotations=function(n){var i=this;if(0!=i.options.enableAnnotation){var o=i.targetObject;n=parseInt(n,10);var a=i.contentSource,s=t(o.getContentLayer(n));if(s.empty(),n>0&&n<=i.pageCount){if(i.contentSourceType==u.PDF){k(n);var r=n;i.options.pageSize==e.PAGE_SIZE.DOUBLEINTERNAL&&n>2&&(r=Math.ceil((n-1)/2)+1),a.getPage(r).then((function(e){if(null!=s&&s.length>0){var t=e.getViewport({scale:1});t=e.getViewport({scale:i.normalViewport.height/t.height*i.viewport.height/t.height}),i.setupAnnotations(e,t,s,n)}}))}if(null!=i.links&&null!=i.links[n])for(var l=i.links[n],c=0;c<l.length;c++){var d,h=l[c];h.dest&&h.dest.indexOf&&0==h.dest.indexOf("[html]")?((d=document.createElement("div")).innerHTML=h.dest.substr(6),d.className="customHtmlAnnotation"):((d=document.createElement("a")).setAttribute("dest",h.dest),d.className="customLinkAnnotation",d.href="#"+h.dest,d.onclick=function(){var e=this.getAttribute("dest");return e&&i.linkService.customNavigateTo(e),!1}),d.style.left=h.x+"%",d.style.top=h.y+"%",d.style.width=h.w+"%",d.style.height=h.h+"%",s[0].appendChild(d)}if(null!=i.html&&null!=i.html[n]){var p=i.html[n];s.append(t("<div class='customHTMLAnnotation'>").html(p))}}}},i.prototype.setPage=function(e,t,n,i){var o=this,a=o.targetObject,r=M(a),l=F(a);if(1==i){o.targetObject.container.find("#df-thumb"+e).css({backgroundImage:P(t)})}else{t==s.textureLoadFallback&&S("Fallback on "+e);var c=a.getPageByNumber(e);null!=c?e%2!=0&&!r||e%2!=1&&r&&!l||l&&!r?(S(e+"rendered to back of "+c.color),c.backImage(t,(function(t,i){c.backTextureLoaded=!0,o.setLoading(e),o.requiresImageTextureScaling&&i&&1!=e&&e!=o.pageCount&&(i.repeat.x=.5,i.offset.x=.5),null!=n&&n()}))):(S(e+"rendered to front of "+c.color),c.frontImage(t,(function(t,i){c.frontTextureLoaded=!0,o.setLoading(e),o.requiresImageTextureScaling&&i&&1!=e&&e!=o.pageCount&&(i.repeat.x=.5),null!=n&&n()}))):S("Invalid set request on Page "+e)}},i.prototype.setupAnnotations=function(n,i,o,a){if(null!=o&&0!=t(o).length){var r=this,l=M(this.targetObject);return n.getAnnotations().then((function(c){if(i=i.clone({dontFlip:!0}),r.options.pageSize,e.PAGE_SIZE.DOUBLEINTERNAL,null!=o){0==(o=t(o)).find(".annotationDiv").length&&o.append(t("<div class='annotationDiv'>"));var d=o.find(".annotationDiv");if(d.empty(),r.options.pageSize==e.PAGE_SIZE.DOUBLEINTERNAL&&a>1&&a<r.pageCount&&(!l&&a%2==1||l&&a%2==0)?d.css({left:"-100%"}):1==a&&d.css({left:""}),pdfjsLib.AnnotationLayer.render({annotations:c,div:d[0],page:n,viewport:i,imageResourcesPath:s.imageResourcesPath,linkService:r.linkService}),r.options.annotationClass&&""!==r.options.annotationClass&&d.find(" > section").addClass(r.options.annotationClass),1==r.options.search){0==o.find(".textLayerDiv").length&&o.append(t("<div class='textLayerDiv'>"));var u=o.find(".textLayerDiv");n.getTextContent().then((function(t){var n=new e.TextLayerBuilder({textLayerDiv:u[0],pageIndex:null,viewport:i.clone({dontFlip:!1})});n.setTextContent(t),n.render()}))}}}))}},i}(),V=function(){function n(e){this.angles=e.angles||[0,0,0,0,0,0],this.stiffness=e.angles||.1,this.segments=e.segments||1,this.canvasMode=e.contentSourceType!==u.IMAGE&&0==e.canvasToBlob,this.initDOM()}function i(e){var n=e.contentLayer=t(g.div,{class:"df-page-content"});e.append(n)}return n.prototype={initDOM:function(){var e=this.element=t(g.div,{class:"df-book-page"}),n=this.wrapper=t(g.div,{class:"df-page-wrapper"}),o=this.front=t(g.div,{class:"df-page-front"}),a=this.back=t(g.div,{class:"df-page-back"}),s=this.foldInnerShadow=t(g.div,{class:"df-page-fold-inner-shadow"}),r=this.foldOuterShadow=t(g.div,{class:"df-page-fold-outer-shadow"});this.frontIMG=new Image,this.backIMG=new Image,i(o,this.segments),i(a,this.segments),e.append(n).append(r),n.append(o).append(a).append(s)},updatePoint:function(t){if(null!=t){var n=null!=this.parent.dragPage?this.parent.dragPage:null!=t.page?t.page:this,i=n.element.width(),o=n.element.height(),a=null!=this.parent.corner?this.parent.corner:t.corner,s=e.CORNERS,r=n.side==h.right,l=a==s.BL||a==s.BR;t.rx=1==r?2*i-t.x:t.x,t.ry=1==l?o-t.y:t.y;var c=Math.atan2(t.ry,t.rx);c=Math.PI/2-x(c,0,m(90));var d=r?t.x/2:i-t.x/2,u=t.ry/2,p=Math.max(0,Math.sin(c-Math.atan2(u,d))*y(d,u)),g=.5*y(t.rx,t.ry),f=Math.round(i-p*Math.sin(c)),P=Math.round(p*Math.cos(c)),C=v(c),L=l?r?90-C+180:180+C:r?C:90-C,S=l?r?90-C+180:C:r?C+180:L,I=l?r?90-C:C+90:r?L-90:L+180,E=r?i-f:f,k=l?o+P:-P,T=r?-f:f-i,O=l?-o-P:P,F=x(.5*t.distance/i,0,.5),M=x(.5*(2*i-t.rx)/i,.05,.3);n.element.addClass("df-folding");var D=r?n.back:n.front,N=r?n.front:n.back,z=n.foldOuterShadow,B=n.foldInnerShadow;n.wrapper.css({transform:b(E,k)+w(L)}),D.css({transform:w(-L)+b(-E,-k)}),N.css({transform:w(S)+b(T,O),boxShadow:"rgba(0, 0, 0, "+F+") 0px 0px 20px"}),B.css({transform:w(S)+b(T,O),opacity:M/2,backgroundImage:R.css+"linear-gradient( "+I+"deg, rgba(0, 0, 0, 0.25) , rgb(0, 0, 0) "+.7*g+"px, rgb(255, 255, 255) "+g+"px)"}),z.css({opacity:M/2,left:r?"auto":0,right:r?0:"auto",backgroundImage:R.css+"linear-gradient( "+(180-I)+"deg, rgba(0, 0, 0,0) "+g/3+"px, rgb(0, 0, 0) "+g+"px)"})}},updateAngle:function(e,t){var n=5*this.element.width();this.wrapper.css({perspective:n,perspectiveOrigin:1==t?"0% 50%":"100% 50%"}),this.front.css({display:1==t?e<=-90?"block":"none":e<90?"block":"none",transform:("MfS"!==R.dom?"":"perspective("+n+"px) ")+(1==t?"translateX(-100%) ":"")+"rotateY("+((1==t?180:0)+e)+"deg)"}),this.back.css({display:1==t?e>-90?"block":"none":e>=90?"block":"none",transform:("MSd"!==R.dom?"":"perspective("+n+"px) ")+(0==t?"translateX(100%) ":"")+"rotateY("+((0==t?-180:0)+e)+"deg)"})},tween:function(t){var n=this;if(null!=n&&null!=n.parent){var i,o=F(n.parent),a=n.side==h.right,s=n.parent.direction==e.DIRECTION.RTL,r=n.parent.corner==e.CORNERS.BL||n.parent.corner==e.CORNERS.BR,l=1==n.magnetic,c=r?n.parent.height:0,d=0,u=n.end=n&&1==n.animateToReset?{x:a?n.parent.fullWidth:0,y:c}:{x:a?0:n.parent.fullWidth,y:c};n.ease=n.isHard?TWEEN.Easing.Quadratic.InOut:TWEEN.Easing.Linear.None;var p=n.parent.duration;1==n.isHard?(null!=t&&(d=L(t.distance,t.fullWidth)),i=n.init={angle:d*(a?-1:1)},u=n.end=n&&1==n.animateToReset?{angle:a?0:-0}:{angle:a?-180:180}):null==t?(i=n.init=n&&1==n.animateToReset?{x:a?0:n.parent.fullWidth,y:0}:{x:a?n.parent.fullWidth:0,y:0},n.first={x:(a?3:1)*n.parent.fullWidth/4,y:0},n.mid={x:(a?1:3)*n.parent.fullWidth/4,y:0}):(i=n.init={x:t.x,y:t.y,opacity:1},n.first={x:3*t.x/4,y:3*t.y/4,opacity:1},n.mid={x:t.x/4,y:t.y/4,opacity:1},p=n.parent.duration*C(i.x,i.y,u.x,u.y)/n.parent.fullWidth,p=x(p,n.parent.duration/3,n.parent.duration)),i.index=0,u.index=1,n.isFlipping=!0;var g=function(e){1==n.isHard?(n.updateAngle(e.angle,a),n.angle=e.angle):(n.updatePoint({x:e.x,y:e.y}),n.x=e.x,n.y=e.y),o&&!l&&(n.element[0].style.opacity=a&&!s||!a&&s?e.index>.5?2*(1-e.index):1:e.index<.5?2*e.index:1)};o&&(!a&&!s||a&&s)&&(n.element[0].style.opacity=0);n.completeTween=n.completeTween||function(t){n.isFlipping=!1,1==n.isHard?(n.updateAngle(n.end.angle),n.back.css({display:"block"}),n.front.css({display:"block"})):n.updatePoint({x:n.end.x,y:n.end.y}),n.element[0].style.opacity=1,!0!==n.animateToReset?n.side=n.side==h.right?h.left:h.right:n.animateToReset=null,n.currentTween=null,n.pendingPoint=null,n.magnetic=!1,n.parent.dragPage=null,n.parent.corner=e.CORNERS.NONE,1!=t&&n.parent.refresh()};1==n.isHard?n.currentTween=new TWEEN.Tween(i).delay(0).to(u,n.parent.duration).onUpdate((function(){g(this)})).easing(n.ease).onComplete(n.completeTween).start():null==t?n.currentTween=new TWEEN.Tween(i).delay(0).to(u,n.parent.duration).onUpdate((function(){g(this)})).easing(TWEEN.Easing.Sinusoidal.Out).onComplete(n.completeTween).start():(n.currentTween=new TWEEN.Tween(i).delay(0).to(u,p).onUpdate((function(){g(this)})).easing(TWEEN.Easing.Sinusoidal.Out).onComplete(n.completeTween),n.currentTween.start())}},frontImage:function(e,n){var i=this;function o(){i.front.css({backgroundImage:P(e)}),null!=n&&n()}1==i.canvasMode?(i.front.find(">canvas").remove(),e!==s.textureLoadFallback&&i.front.append(t(e)),null!=n&&n()):e==s.textureLoadFallback?o():(i.frontIMG.onload=o,i.frontIMG.src=e)},backImage:function(e,n){var i=this;function o(){i.back.css({backgroundImage:P(e)}),null!=n&&n()}1==i.canvasMode?(i.back.find(">canvas").remove(),e!==s.textureLoadFallback&&i.back.append(t(e)),null!=n&&n()):e==s.textureLoadFallback?o():(i.backIMG.onload=o,i.backIMG.src=e)},updateCSS:function(e){this.element.css(e)},resetCSS:function(){this.wrapper.css({transform:""}),this.front.css({transform:"",boxShadow:""}),this.back.css({transform:"",boxShadow:""})},clearTween:function(e){this.currentTween.stop(),this.completeTween(1==e),this.resetCSS()}},n}(),G=function(n){function i(e){for(var t=!1,n=0;n<e.pages.length;n++){if(1==e.pages[n].isFlipping){t=!0;break}}return t}function o(n,o){var a=this;function s(e){a.dragPage!=e.page&&1==e.page.visible&&(a.dragPage.clearTween(!0),a.dragPage=e.page,a.corner=e.corner,a.dragPage.pendingPoint=e)}a.type="BookCSS",a.images=n.images||[],a.pageCount=n.pageCount||1,a.foldSense=50,a.stackCount=4,a.mode="css",a.pages=[],a.duration=n.duration,a.container=t(o),a.options=n,a.drag=h.none,a.pageMode=n.pageMode||(D||a.pageCount<=2?e.PAGE_MODE.SINGLE:e.PAGE_MODE.DOUBLE),a.singlePageMode=n.singlePageMode||(D?e.SINGLE_PAGE_MODE.BOOKLET:e.SINGLE_PAGE_MODE.ZOOM),a.swipe_threshold=D?15:50,a.direction=n.direction||e.DIRECTION.LTR,a.startPage=1,a.endPage=a.pageCount,a._activePage=n.openPage||a.startPage,a.hardConfig=n.hard,r="WebKitCSSMatrix"in window||document.body&&"MozPerspective"in document.body.style,a.animateF=function(){TWEEN.getAll().length>0?TWEEN.update():clearInterval(a.animate)},a.init(n),a.skipDrag=!1;var l=function(t){var n=a.eventToPoint(t);if(null!=t.touches&&2==t.touches.length&&null!=a.startTouches){a.zoomDirty=!0;var o=d.getVectorAvg(d.getTouches(t,a.container.offset())),s=d.calculateScale(a.startTouches,d.getTouches(t));a.lastScale,a.contentProvider.zoomScale,o.x,o.y;a.stage.css({transform:"translate3d("+a.left+"px,"+a.top+"px,0) scale3d("+s+","+s+",1)"}),a.lastScale=s,a.lastZoomCenter=o,t.preventDefault()}if(!(null!=t.touches&&t.touches.length>1||null==a.startPoint||null!=a.startTouches)){var r=a.dragPage||n.page;if(1!==a.contentProvider.zoomScale)null==t.touches&&1!=a.isPanning||(a.pan(n),t.preventDefault());else if(!0!==a.skipDrag){n.distance;if(!i(a)){if(null!=a.dragPage||1==n.isInside){null!=a.dragPage?S("set mouse down move"):(n.y=x(n.y,1,a.height-1),n.x=x(n.x,1,n.fullWidth-1));var l=a.corner||n.corner;if(r.isHard){var c=l==e.CORNERS.BR||l==e.CORNERS.TR,u=L(n.distance,n.fullWidth);r.updateAngle(u*(c?-1:1),c)}else r.updatePoint(n,a);r.magnetic=!0,r.magneticCorner=n.corner,t.preventDefault()}if(null==a.dragPage&&null!=r&&0==n.isInside&&1==r.magnetic&&(r.pendingPoint=n,r.animateToReset=!0,a.corner=r.magneticCorner,a.animatePage(r),r.pendingPoint=null,r.magnetic=!1,r.magneticCorner=null),1==a.isPanning&&null==a.dragPage&&1==a.contentProvider.zoomScale){var p=n.x-a.lastPos;performance.now(),a.lastTime;Math.abs(p)>a.swipe_threshold&&(p<0?a.next():a.prev(),a.drag=h.none,a.isPanning=!1,t.preventDefault()),a.lastPos=n.x,a.lastTime=performance.now()}}}}},c=function(t){if(null!=t.touches&&0==t.touches.length){a.contentProvider.zoomScale;1==a.zoomDirty&&(a.previewObject.contentProvider.zoomScale=d.limitAt(a.previewObject.contentProvider.zoomScale*a.lastScale,1,a.previewObject.contentProvider.maxZoom),a.previewObject.zoomValue=1*a.previewObject.contentProvider.zoomScale,a.previewObject.resize(),a.zoomDirty=!1),a.wrapper.css({transform:""}),a.lastScale=null,a.startTouches=null}if(a.isPanning=!1,!(null!=t.touches&&t.touches.length>1)&&!0!==a.skipDrag){var n=a.eventToPoint(t);a.dragPage&&(t.preventDefault(),a.dragPage.pendingPoint=n,n.x==a.startPoint.x&&n.y==a.startPoint.y&&1==n.isInside?a.corner==e.CORNERS.BR||a.corner==e.CORNERS.TR?(s(n),!0!==a.dragPage.isFlipping&&a.next()):a.corner!=e.CORNERS.BL&&a.corner!=e.CORNERS.TL||(s(n),!0!==a.dragPage.isFlipping&&a.prev()):!0!==a.dragPage.isFlipping&&(n.distance>n.fullWidth/2?n.x>n.fullWidth/2?a.prev():a.next():(a.dragPage.animateToReset=!0,a.animatePage(a.dragPage))),a.dragPage&&(a.dragPage.pendingPoint=null,a.dragPage.magnetic=!1)),a.drag=h.none}},u=function(t){var n=a.eventToPoint(t),i=t.srcElement||t.originalTarget;a.dragPage&&a.dragPage.magnetic||a.wrapper[0].contains(t.target)&&1==a.contentProvider.zoomScale&&n.x==a.startPoint.x&&n.y==a.startPoint.y&&n.isInsidePage&&a.startPoint.page==n.page&&!n.page.isFlipping&&"A"!==i.nodeName&&(0==a.startPoint.page.side?(a.corner=e.CORNERS.TL,a.prev(),a.startPoint.page=null):(a.corner=e.CORNERS.TR,a.next(),a.startPoint.page=null),a.isPanning=!1)},p=function(t){if(null!=t.touches&&2==t.touches.length&&null==a.startTouches&&(a.startTouches=d.getTouches(t),a.lastScale=1),!(null!=t.touches&&t.touches.length>1||null==t.touches&&0!==t.button)){var n,o=a.eventToPoint(t);a.startPoint=o,a.left=a.left||0,a.top=a.top||0,a.isPanning=!0,a.lastPos=o.x,a.lastTime=performance.now(),!0!==a.skipDrag&&(1!=o.isInside||i(a)||(a.startPoint=o,a.drag=o.drag,a.dragPage=o.page,a.corner=o.corner,S(a.corner),(n=a.dragPage).parent.container.find(".df-folding").removeClass("df-folding"),n.element.addClass("df-folding"),o.page.isHard||o.page.updatePoint(o,a),"0"==o.page.name?a.shadow.css({width:"50%",left:a.direction==e.DIRECTION.RTL?0:"50%",transitionDelay:""}):o.page.name==Math.ceil(a.pageCount/2)-1&&a.shadow.css({width:"50%",left:a.direction==e.DIRECTION.RTL?"50%":0,transitionDelay:""})))}},g=function(e){if(!0===a.previewObject.options.isLightBox||!0===a.previewObject.ui.isFullscreen){var t=0;null!=e.wheelDelta?t=e.wheelDelta/120:null!=e.detail&&(t=-e.detail/3);var n=a.contentProvider.zoomScale,i=a.contentProvider.maxZoom;if(t&&(t>0&&n<i||t<0&&n>1)){e.stopPropagation(),e.preventDefault();var o=a.eventToPoint(e),s=a.eventToPoint(e),r={x:a.container.width()/2,y:a.container.height()/2-23};a.previewObject.zoom(t);var l=a.contentProvider.zoomScale;if(n!==l){var c=l/n;1==l?(a.left=0,a.top=0):(a.left*=c,a.top*=c);var d=(o.raw.x-r.x)*c,u=(o.raw.y-r.y)*c;s.raw.x=r.x+d,s.raw.y=r.y+u,a.startPoint=s,a.pan(o);var h=a.dragPage||o.page;null==a.dragPage&&null!=h&&1==o.isInside&&1==h.magnetic&&(h.pendingPoint=o,h.animateToReset=!0,a.corner=h.magneticCorner,a.animatePage(h),h.pendingPoint=null,h.magnetic=!1,h.magneticCorner=null)}}}},f=a.container[0],m=a.stage[0];f&&(m.addEventListener("mousemove",l,!1),m.addEventListener("touchmove",l,!1),m.addEventListener("mousedown",p,!1),m.addEventListener("click",u,!1),m.addEventListener("mouseup",c,!1),m.addEventListener("touchend",c,!1),m.addEventListener("touchstart",p,!1),1==a.options.scrollWheel&&(m.addEventListener("mousewheel",g,!1),m.addEventListener("DOMMouseScroll",g,!1))),this.dispose=function(){m.removeEventListener("mousemove",l,!1),m.removeEventListener("touchmove",l,!1),m.removeEventListener("mousedown",p,!1),m.removeEventListener("click",u,!1),m.removeEventListener("mouseup",c,!1),m.removeEventListener("touchend",c,!1),m.removeEventListener("touchstart",p,!1),1==a.options.scrollWheel&&(m.removeEventListener("mousewheel",g,!1),m.removeEventListener("DOMMouseScroll",g,!1)),a.updatePageCallback=null,a.flipCallback=null,a.animateF=null,a.stage.remove()}}return _(o,{}),o.prototype={add:function(e){e instanceof V?this.container.append(t(e.element)):this.container.append(t(e))},pan:function(e){var t=this.startPoint,n=this.contentProvider.zoomScale,i=this.left+(e.raw.x-t.raw.x),o=this.top+(e.raw.y-t.raw.y);this.left=Math.round(x(i,-this.shiftWidth,this.shiftWidth)),this.top=Math.round(x(o,-this.shiftHeight,this.shiftHeight)),1==n&&(this.left=0,this.top=0),this.startPoint=e,this.stage.css({transform:"translate3d("+this.left+"px,"+this.top+"px,0)"})},getPageByNumber:function(e){for(var t,n=F(this)?M(this)?e+1:e:Math.floor((e-1)/2),i=0;i<this.pages.length;i++)n==parseInt(this.pages[i].name,10)&&(t=this.pages[i]);return t},getPageSide:function(t){var n=this.direction==e.DIRECTION.RTL,i=this.getPageByNumber(t);if(null!=i)return F(this)?n?i.front:i.back:t%2==0?n?i.back:i.front:n?i.front:i.back},getContentLayer:function(e){var t=this.getPageSide(e);return null==t?null:t.contentLayer}},o.prototype.init=function(e){var n=this;n.stage=t(g.div,{class:"df-book-stage"}),n.wrapper=t(g.div,{class:"df-book-wrapper"}),n.shadow=t(g.div,{class:"df-book-shadow"}),n.container.append(n.stage),n.stage.append(n.wrapper),n.wrapper.append(n.shadow),n.createStack(e)},o.prototype.createStack=function(e){for(var t="red,green,blue,yellow,orange,black".split(","),n=0;n<this.stackCount;n++){e.angles=[,this.stackCount-n],e.stiffness=(this.stackCount-n)/100;var i=new V(e);i.angles[1]=180,i.index=n,i.parent=this,i.textureReady=!1,i.textureRequested=!1,this.wrapper.append(i.element),i.isFlipping=!1,this.pages.push(i),i.color=t[n]}this.children=this.pages},o.prototype.isPageHard=function(e){return d.isHardPage(this.hardConfig,e,this.pageCount,F(this))},o.prototype.setDuration=function(e){this.duration=e},o.prototype.moveBy=function(e){var t=this._activePage+e;t=x(t,this.startPage,this.endPage),1!=this.firstFlipped&&(this.previewObject.analytics({eventAction:"First Page Flip",options:this.previewObject.options}),this.firstFlipped=!0),this.gotoPage(t)},o.prototype.next=function(t){null==t&&(t=this.direction==e.DIRECTION.RTL?-this.pageMode:this.pageMode),this.moveBy(t)},o.prototype.prev=function(t){null==t&&(t=this.direction==e.DIRECTION.RTL?this.pageMode:-this.pageMode),this.moveBy(t)},o.prototype.eventToPoint=function(n){n=O(n);var i=this.wrapper,o=this.pages,a=this.pageWidth,s=this.fullWidth,r=this.height,l=(t(window),{x:n.clientX,y:n.clientY}),c=l.x-i[0].getBoundingClientRect().left,d=l.y-i[0].getBoundingClientRect().top;l.x=l.x-this.container[0].getBoundingClientRect().left,l.y=l.y-this.container[0].getBoundingClientRect().top;var u,p=this.drag==h.none?c<a?c:s-c:this.drag==h.left?c:s-c,g=c<a?o[this.stackCount/2-1]:o[this.stackCount/2],f=c<this.foldSense?h.left:c>s-this.foldSense?h.right:h.none,m=c,v=d,b=r,w=s,P=this.foldSense,x=e.CORNERS;return{isInsidePage:m>=0&&m<=w&&v>=0&&v<=b,isInside:(u=m>=0&&m<P?v>=0&&v<=P?x.TL:v>=b-P&&v<=b?x.BL:v>P&&v<b-P?x.L:x.NONE:m>=w-P&&m<=w?v>=0&&v<=P?x.TR:v>=b-P&&v<=b?x.BR:v>P&&v<b-P?x.R:x.NONE:x.NONE)!==x.NONE&&u!==x.L&&u!==x.R,x:c,y:d,fullWidth:s,rawDistance:s-c,distance:p,page:g,drag:f,foldSense:this.foldSense,event:n,raw:l,corner:u}},o.prototype.gotoPage=function(e){e=parseInt(e,10),this._activePage=e,1==this.autoPlay&&this.previewObject.setAutoPlay(this.autoPlay),this.updatePage(e),this&&this.thumblist&&this.thumblist.review&&this.thumblist.review()},o.prototype.refresh=function(){this.updatePage(this._activePage),null!=this.flipCallback&&this.flipCallback()},o.prototype.updatePage=function(n){var i=this.direction==e.DIRECTION.RTL,o=F(this),a=(k(n),o?1:2);n=Math.floor(n/a),i&&(n=Math.ceil(this.pageCount/a)-n);var r=this.oldBaseNumber||0,l=this.pageCount/a,c=this.stackCount,d=Math.floor(c/2);r>n?(this.children[c-1].skipFlip=!0,this.children.unshift(this.children.pop())):r<n&&(this.children[0].skipFlip=!0,this.children.push(this.children.shift()));for(var u=0;u<c;u++){var p=this.children[u];r!==n&&null!=p.currentTween&&p.clearTween(!0);var g,f=p.side,m=n-d+u;i&&(m=o?this.pageCount-m:Math.ceil(this.pageCount/2)-m-1);var v=p.name;p.isHard=this.isPageHard(m),p.isHard?p.element.addClass("df-hard-page"):(p.element.removeClass("df-hard-page"),p.front.css({display:"block"}),p.back.css({display:"block"})),0==m||m==l?p.element.addClass("df-cover-page"):p.element.removeClass("df-cover-page"),t(p.element).attr("pageNumber")!=m&&(p.front.contentLayer.empty(),p.back.contentLayer.empty()),t(p.element).attr("pageNumber",m),p.isEdge=!1,0==u||u==c-1||(p.isEdge=!1),g=u<d?h.left:h.right,0==p.isFlipping&&(g!==f&&0==p.skipFlip?(this.animatePage(p),null!=this.preFlipCallback&&this.preFlipCallback()):(p.skipFlip=!1,p.element.removeClass("df-flipping df-quick-turn df-folding df-left-side df-right-side"),p.element.addClass(u<d?"df-left-side":"df-right-side"),p.side=g)),p.visible=o?i?u<d||p.isFlipping:u>=d||p.isFlipping:m>=0&&m<l||o&&m==l,null!=this.requestPage&&1==p.visible&&(p.name=m.toString(),p.name!=v&&(p.backTextureLoaded=!1,p.frontTextureLoaded=!1,p.backPageStamp="-1",p.frontPageStamp="-1",p.thumbLoaded=!1,p.front.contentLayer.html(""),p.back.contentLayer.html(""),p.frontImage(s.textureLoadFallback),p.backImage(s.textureLoadFallback),this.requestPage())),p.oldDepth=p.depth,p.updateCSS({display:1==p.visible?"block":"none",zIndex:6+(u<d?u-d:d-u),transform:""}),null==p.pendingPoint&&0==p.isFlipping&&p.resetCSS()}0==TWEEN.getAll().length&&clearInterval(this.animate),t(".quick-hint").html(n),this.oldBaseNumber=n,this.updatePageCallback&&this.updatePageCallback()},o.prototype.animatePage=function(e){e.element.addClass("df-flipping"),e.isFlipping=!0,null!=this.animate&&clearInterval(this.animate),this.animate=setInterval(this.animateF,30),e.tween(e.pendingPoint)},o}(),q=function(n){function i(i,o,a){n.call(this,a);var s=this;s.type="FlipBook",s.container=i,s.options=a,s.options.source=o,s.contentSource=o,null!=a.height&&a.height.toString().indexOf("%")<0?s.container.height(Math.min(a.height,t(window).height())):s.container.height(a.height),s.options.isLightBox&&window.dfLightBox.closeButton.addClass(s.options.icons.close),s.options.pageSize==e.PAGE_SIZE.DOUBLEINTERNAL&&((Array===s.contentSource.constructor||Array.isArray(s.contentSource)||s.contentSource instanceof Array)&&(s.options.singlePageMode=e.SINGLE_PAGE_MODE.ZOOM),s.container.addClass("df-double-internal")),s.options.isLightBox||null==s.container.attr("id")||(s.options.id=s.container.attr("id")),!0!==s.options.parsed&&null!=s.options.links&&e.parseLinks(s.options.links);var r=s.webgl=1==a.webgl&&1==N&&d.canSupport3D();if(i.addClass("df-container df-loading df-init df-floating df-controls-"+s.options.controlsPosition),s.commentPopup=t('<div class="df-comment-popup">').appendTo(i),1==s.options.transparent&&i.addClass("df-transparent"),s.options.direction==e.DIRECTION.RTL&&i.addClass("df-rtl"),s.container.info=t(g.div,{class:"loading-info"}).appendTo(s.container).html(s.options.text.loading+"..."),c.match(/msie\s[5-9]/i))return s.container.info.html("Your browser (Internet Explorer) is out of date to run DFlip Flipbook Plugin. <br><a href='http://browsehappy.com/'>Upgrade to a new one</a>").addClass("df-old-browser"),i.removeClass("df-loading"),s;var l=null==a.backgroundImage||""==a.backgroundImage?"":"url('"+a.backgroundImage+"')";return s.container.css({position:"relative",overflow:"hidden",backgroundColor:a.backgroundColor,backgroundImage:l}),1==s.options.isLightBox&&s.analytics({eventAction:"Open Book",options:s.options}),s.init(r,o),null!=s.options.onCreate&&s.options.onCreate(s),s}return _(i,n),i.prototype.init=function(n){var i,o,a=this,r=a.target,l=a.options;if(1==n){i=function(){a.container.css({minHeight:300,minWidth:300}),a.stage=new j(E(a.options,{container:a.container})),a.stage.previewObject=a,a.contentProvider=new W(a.contentSource,(function(i){var o={pageCount:i.pageCount,stackCount:6,segments:20,width:i.bookSize.width,height:i.bookSize.height};a.target=r=a.stage.target=new MOCKUP.Book(E(a.options,o),a.stage),a.extendtarget(),A(a.container,a),r.ui=a.ui,r.container=a.container,i.webgl=n,i.setTarget(a.target),r.getContentLayer=function(t){var n=r.direction==e.DIRECTION.RTL,i=a.stage.cssScene.divLeft.element,o=a.stage.cssScene.divRight.element;return k(r._activePage),F(r)?n?i:o:t%2==0?n?o:i:n?i:o},r.stage=a.stage,r.flipCallback=function(){if(a.contentProvider){a.contentProvider.review("flipCallback");var n,i,o=k(r._activePage),s=r.getPageByNumber(o),l=r.getPageByNumber(o+1),c=r.parent.cssScene.divLeft,d=r.parent.cssScene.divRight;r.pageMode,e.PAGE_MODE.SINGLE,r.direction,e.DIRECTION.RTL,null!=s&&null!=c&&(n=Math.abs(s.geometry.boundingBox.max.x-s.geometry.boundingBox.min.x),i=Math.abs(s.geometry.boundingBox.max.z-s.geometry.boundingBox.min.z),c.rotation.y=.9*-Math.atan2(i,n),c.position.z=.8*i,c.position.x=i/2.5,t(c.element).css({width:n,left:-n/2})),null!=l&&null!=d&&(n=Math.abs(l.geometry.boundingBox.max.x-l.geometry.boundingBox.min.x),i=Math.abs(l.geometry.boundingBox.max.z-l.geometry.boundingBox.min.z),d.rotation.y=.9*Math.atan2(i,n),d.position.z=.8*i,d.position.x=-i/2.5,t(d.element).css({width:n,left:n/2})),null!=a.options.onFlip&&a.options.onFlip(a)}},r.resize=void a.resize(),r.updatePageCallback=function(){a.ui.update(),a.checkCenter(),a.stage.renderRequestPending=!0};var s=t(a.stage.cssScene.divLeft.element),l=t(a.stage.cssScene.divRight.element);r.preFlipCallback=function(){s.empty(),l.empty(),null!=a.options.beforeFlip&&a.options.beforeFlip(a),a.playSound()},t(window).trigger("resize"),s.css({width:i.bookSize.width,height:i.bookSize.height,left:-i.bookSize.width/2}),l.css({width:i.bookSize.width,height:i.bookSize.height,left:i.bookSize.width/2}),r.ease=TWEEN.Easing.Cubic.InOut,r.contentProvider=i,r.duration=a.options.duration,r.gotoPage(r._activePage),r.flipCallback(),1==a.options.isLightBox&&a.analytics({eventAction:"Book Ready",options:a.options}),null!=a.options.onReady&&a.options.onReady(a)}),l,a)},o=function(){MOCKUP.defaults.anisotropy=0,MOCKUP.defaults.groundTexture="blank",THREE.skipPowerOfTwo=!0,U(),null!=i&&i()},null==window.MOCKUP?(a.updateInfo(l.text.loading+" WEBGL 3D ..."),"function"==typeof define&&define.amd&&window.requirejs?(requirejs.config({paths:{three:s.threejsSrc.replace(".js","")},shim:{three:{exports:"THREE"}}}),require(["three"],(function(t){return window.THREE=t,T(s.mockupjsSrc+"?ver="+e.version,(function(){o()})),t}))):"function"==typeof define&&define.amd?require(["three",s.threejsSrc.replace(".js","")],(function(e,t){e((function(){}))})):T(s.threejsSrc+"?ver="+e.version,(function(){T(s.mockupjsSrc+"?ver="+e.version,(function(){o()}))}))):o()}else a.contentProvider=new W(a.contentSource,(function(e){var i={pageCount:e.pageCount,contentSourceType:e.contentSourceType};a.target=r=new G(E(a.options,i),a.container),a.target.previewObject=a,a.extendtarget(),A(a.container,a),e.webgl=n,e.setTarget(a.target),e.waitPeriod=2,r.ease=TWEEN.Easing.Quadratic.InOut,r.duration=a.options.duration,r.container=a.container,r.updatePageCallback=function(){a.ui.update(),a.checkCenter()},r.resize=void a.resize(),t(window).trigger("resize"),r.flipCallback=function(){a.contentProvider&&(a.contentProvider.review("flipCallback"),null!=a.options.onFlip&&a.options.onFlip(a))},r.preFlipCallback=function(){null!=a.options.beforeFlip&&a.options.beforeFlip(a),a.playSound()},r.gotoPage(r._activePage),r.flipCallback(),null!=a.options.onReady&&a.options.onReady(a),a.analytics({eventAction:"Book Ready",options:a.options})}),l,a)},i.prototype.extendtarget=function(){var e=this;e.target.previewObject=e,e.target.reset=function(){for(var t=0;t<e.target.children.length;t++){var n=e.target.children[t];n.skipFlip=!0,n.name="-2"}e.contentProvider.annotedPage="-2",e.target.refresh()}},i.prototype.getURLHash=function(){if(null!=this.options.id){var e=d.getSharePrefix()+(null!=this.options.slug?this.options.slug:this.options.id)+"/";null!=this.target&&null!=this.target._activePage&&(e+=this.target._activePage+"/"),window.location.hash=e}return window.location.href},i.prototype.end=function(){this.target.gotoPage(this.target.endPage)},i.prototype.gotoPage=function(e){this.target.gotoPage(e),null!=this.ui&&this.ui.update()},i.prototype.prev=function(){this.target.prev()},i.prototype.next=function(){this.target.next()},i.prototype.updateInfo=function(e){this.container&&this.container.info&&this.container.info.html&&this.container.info.html(e)},i.prototype.analytics=function(e){if(1==this.options.enableAnalytics)try{var t=e.options,n=void 0;t&&(n=t.bookTitle||t.slug||t.id);var i=window.gtag;if(i)i("event",e.eventAction,{event_category:"Flipbook",event_label:n});else(window.ga||window.__gaTracker)("send",{hitType:"event",eventCategory:"Flipbook",eventAction:e.eventAction,eventLabel:n})}catch(e){}},i}(H);t.fn.extend({shelf:function(){},flipBook:function(e,n){return new q(t(this),e,function(e){return t.extend(!0,{},s,e)}(n))}})}(DFLIP,jQuery),function(e){if(e.URL=e.URL||e.webkitURL,e.Blob&&e.URL)try{return void new Blob}catch(e){}var t=e.BlobBuilder||e.WebKitBlobBuilder||e.MozBlobBuilder||function(e){var t=function(e){return Object.prototype.toString.call(e).match(/^\[object\s(.*)\]$/)[1]},n=function(){this.data=[]},i=function(e,t,n){this.data=e,this.size=e.length,this.type=t,this.encoding=n},o=n.prototype,a=i.prototype,s=e.FileReaderSync,r=function(e){this.code=this[this.name=e]},l="NOT_FOUND_ERR SECURITY_ERR ABORT_ERR NOT_READABLE_ERR ENCODING_ERR NO_MODIFICATION_ALLOWED_ERR INVALID_STATE_ERR SYNTAX_ERR".split(" "),c=l.length,d=e.URL||e.webkitURL||e,u=d.createObjectURL,h=d.revokeObjectURL,p=d,g=e.btoa,f=e.atob,m=e.ArrayBuffer,v=e.Uint8Array,b=/^[\w-]+:\/*\[?[\w\.:-]+\]?(?::[0-9]+)?/;for(i.fake=a.fake=!0;c--;)r.prototype[l[c]]=c+1;return d.createObjectURL||(p=e.URL=function(e){var t,n=document.createElementNS("http://www.w3.org/1999/xhtml","a");return n.href=e,"origin"in n||("data:"===n.protocol.toLowerCase()?n.origin=null:(t=e.match(b),n.origin=t&&t[1])),n}),p.createObjectURL=function(e){var t,n=e.type;return null===n&&(n="application/octet-stream"),e instanceof i?(t="data:"+n,"base64"===e.encoding?t+";base64,"+e.data:"URI"===e.encoding?t+","+decodeURIComponent(e.data):g?t+";base64,"+g(e.data):t+","+encodeURIComponent(e.data)):u?u.call(d,e):void 0},p.revokeObjectURL=function(e){"data:"!==e.substring(0,5)&&h&&h.call(d,e)},o.append=function(e){var n=this.data;if(v&&(e instanceof m||e instanceof v)){for(var o="",a=new v(e),l=0,c=a.length;l<c;l++)o+=String.fromCharCode(a[l]);n.push(o)}else if("Blob"===t(e)||"File"===t(e)){if(!s)throw new r("NOT_READABLE_ERR");var d=new s;n.push(d.readAsBinaryString(e))}else e instanceof i?"base64"===e.encoding&&f?n.push(f(e.data)):"URI"===e.encoding?n.push(decodeURIComponent(e.data)):"raw"===e.encoding&&n.push(e.data):("string"!=typeof e&&(e+=""),n.push(unescape(encodeURIComponent(e))))},o.getBlob=function(e){return arguments.length||(e=null),new i(this.data.join(""),e,"raw")},o.toString=function(){return"[object BlobBuilder]"},a.slice=function(e,t,n){var o=arguments.length;return o<3&&(n=null),new i(this.data.slice(e,o>1?t:this.data.length),n,this.encoding)},a.toString=function(){return"[object Blob]"},a.close=function(){this.size=0,delete this.data},n}(e);e.Blob=function(e,n){var i=n&&n.type||"",o=new t;if(e)for(var a=0,s=e.length;a<s;a++)Uint8Array&&e[a]instanceof Uint8Array?o.append(e[a].buffer):o.append(e[a]);var r=o.getBlob(i);return!r.slice&&r.webkitSlice&&(r.slice=r.webkitSlice),r};var n=Object.getPrototypeOf||function(e){return e.__proto__};e.Blob.prototype=n(new e.Blob)}(window),function(e){var t,n=e.Uint8Array,i=e.HTMLCanvasElement,o=i&&i.prototype,a=/\s*;\s*base64\s*(?:;|$)/i,s="toDataURL",r=function(e){for(var i,o,a=e.length,s=new n(a/4*3|0),r=0,l=0,c=[0,0],d=0,u=0;a--;)o=e.charCodeAt(r++),255!==(i=t[o-43])&&null!=i&&(c[1]=c[0],c[0]=o,u=u<<6|i,4===++d&&(s[l++]=u>>>16,61!==c[1]&&(s[l++]=u>>>8),61!==c[0]&&(s[l++]=u),d=0));return s};n&&(t=new n([62,-1,-1,-1,63,52,53,54,55,56,57,58,59,60,61,-1,-1,-1,0,-1,-1,-1,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,-1,-1,-1,-1,-1,-1,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51])),i&&!o.toBlob&&(o.toBlob=function(e,t){if(t||(t="image/png"),this.mozGetAsFile)e(this.mozGetAsFile("canvas",t));else if(this.msToBlob&&/^\s*image\/png\s*(?:$|;)/i.test(t))e(this.msToBlob());else{var i,o=Array.prototype.slice.call(arguments,1),l=this[s].apply(this,o),c=l.indexOf(","),d=l.substring(c+1),u=a.test(l.substring(0,c));Blob.fake?((i=new Blob).encoding=u?"base64":"URI",i.data=d,i.size=d.length):n&&(i=u?new Blob([r(d)],{type:t}):new Blob([decodeURIComponent(d)],{type:t})),e(i)}},o.toDataURLHD?o.toBlobHD=function(){s="toDataURLHD";var e=this.toBlob();return s="toDataURL",e}:o.toBlobHD=o.toBlob)}(window),function(){if("performance"in window==!1&&(window.performance={}),Date.now=Date.now||function(){return(new Date).getTime()},"now"in window.performance==!1){var e=window.performance.timing&&window.performance.timing.navigationStart?window.performance.timing.navigationStart:Date.now();window.performance.now=function(){return Date.now()-e}}}(),function(){var e,t,n=n||(e=[],{getAll:function(){return e},removeAll:function(){e=[]},add:function(t){e.push(t)},remove:function(t){var n=e.indexOf(t);-1!==n&&e.splice(n,1)},update:function(t){if(0===e.length)return!1;var n=0;for(t=null!=t?t:window.performance.now();n<e.length;)e[n].update(t)?n++:e.splice(n,1);return!0}});n.Tween=function(e){var t=e,i={},o={},a={},s=1e3,r=0,l=!1,c=!1,d=!1,u=0,h=null,p=n.Easing.Linear.None,g=n.Interpolation.Linear,f=[],m=null,v=!1,b=null,w=null,P=null;for(var x in e)i[x]=parseFloat(e[x],10);this.to=function(e,t){return null!=t&&(s=t),o=e,this},this.start=function(e){for(var s in n.add(this),c=!0,v=!1,h=null!=e?e:window.performance.now(),h+=u,o){if(o[s]instanceof Array){if(0===o[s].length)continue;o[s]=[t[s]].concat(o[s])}null!==i[s]&&(i[s]=t[s],i[s]instanceof Array==!1&&(i[s]*=1),a[s]=i[s]||0)}return this},this.stop=function(){return c?(n.remove(this),c=!1,null!==P&&P.call(t),this.stopChainedTweens(),this):this},this.stopChainedTweens=function(){for(var e=0,t=f.length;e<t;e++)f[e].stop()},this.complete=function(){return c?(n.remove(this),c=!1,null!==w&&w.call(t),this.completeChainedTweens(),this):this},this.completeChainedTweens=function(){for(var e=0,t=f.length;e<t;e++)f[e].complete()},this.delay=function(e){return u=e,this},this.repeat=function(e){return r=e,this},this.yoyo=function(e){return l=e,this},this.easing=function(e){return p=null==e?p:e,this},this.interpolation=function(e){return g=e,this},this.chain=function(){return f=arguments,this},this.onStart=function(e){return m=e,this},this.onUpdate=function(e){return b=e,this},this.onComplete=function(e){return w=e,this},this.onStop=function(e){return P=e,this},this.update=function(e){var n,c,P;if(e<h)return!0;for(n in!1===v&&(null!==m&&m.call(t),v=!0),P=p(c=(c=(e-h)/s)>1?1:c),o)if(null!==i[n]){var x=i[n]||0,y=o[n];y instanceof Array?t[n]=g(y,P):("string"==typeof y&&(y=y.startsWith("+")||y.startsWith("-")?x+parseFloat(y,10):parseFloat(y,10)),"number"==typeof y&&(t[n]=x+(y-x)*P))}if(null!==b&&b.call(t,P),1===c){if(r>0){for(n in isFinite(r)&&r--,a){if("string"==typeof o[n]&&(a[n]=a[n]+parseFloat(o[n],10)),l){var C=a[n];a[n]=o[n],o[n]=C}i[n]=a[n]}return l&&(d=!d),h=e+u,!0}null!==w&&w.call(t);for(var L=0,S=f.length;L<S;L++)f[L].start(h+s);return!1}return!0}},n.Easing={Linear:{None:function(e){return e}},Quadratic:{In:function(e){return e*e},Out:function(e){return e*(2-e)},InOut:function(e){return(e*=2)<1?.5*e*e:-.5*(--e*(e-2)-1)}},Quartic:{In:function(e){return e*e*e*e},Out:function(e){return 1- --e*e*e*e},InOut:function(e){return(e*=2)<1?.5*e*e*e*e:-.5*((e-=2)*e*e*e-2)}},Sinusoidal:{In:function(e){return 1-Math.cos(e*Math.PI/2)},Out:function(e){return Math.sin(e*Math.PI/2)},InOut:function(e){return.5*(1-Math.cos(Math.PI*e))}},Cubic:{In:function(e){return e*e*e},Out:function(e){return--e*e*e+1},InOut:function(e){return(e*=2)<1?.5*e*e*e:.5*((e-=2)*e*e+2)}}},n.Interpolation={Linear:function(e,t){var i=e.length-1,o=i*t,a=Math.floor(o),s=n.Interpolation.Utils.Linear;return t<0?s(e[0],e[1],o):t>1?s(e[i],e[i-1],i-o):s(e[a],e[a+1>i?i:a+1],o-a)},Bezier:function(e,t){for(var i=0,o=e.length-1,a=Math.pow,s=n.Interpolation.Utils.Bernstein,r=0;r<=o;r++)i+=a(1-t,o-r)*a(t,r)*e[r]*s(o,r);return i},Utils:{Linear:function(e,t,n){return(t-e)*n+e},Bernstein:function(e,t){var i=n.Interpolation.Utils.Factorial;return i(e)/i(t)/i(e-t)},Factorial:(t=[1],function(e){var n=1;if(t[e])return t[e];for(var i=e;i>1;i--)n*=i;return t[e]=n,n}),CatmullRom:function(e,t,n,i,o){var a=.5*(n-e),s=.5*(i-t),r=o*o;return(2*t-2*n+a+s)*(o*r)+(-3*t+3*n-2*a-s)*r+a*o+t}}},window.TWEEN=n}(),DFLIP.createBlob=function(e,t){if("undefined"!=typeof Blob)return new Blob([e],{type:t});var n=new MozBlobBuilder;return n.append(e),n.getBlob(t)},DFLIP.createObjectURL=function(){var e="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";return function(t,n){if("undefined"!=typeof URL&&URL.createObjectURL){var i=DFLIP.createBlob(t,n);return URL.createObjectURL(i)}for(var o="data:"+n+";base64,",a=0,s=t.length;a<s;a+=3){var r=255&t[a],l=255&t[a+1],c=255&t[a+2];o+=e[r>>2]+e[(3&r)<<4|l>>4]+e[a+1<s?(15&l)<<2|c>>6:64]+e[a+2<s?63&c:64]}return o}}();var ThumbList=function(){function e(t){var n=t&&t.w+"px"||"100%",i=t&&t.h+"px"||"100%",o=this.itemHeight=t.itemHeight;this.items=t.items,this.generatorFn=t.generatorFn,this.totalRows=t.totalRows||t.items&&t.items.length,this.addFn=t.addFn,this.scrollFn=t.scrollFn;var a=e.createScroller(o*this.totalRows);this.container=e.createContainer(n,i),this.container.appendChild(a),this.screenItemsLen=Math.ceil(t.h/o),this.offsetItems=this.screenItemsLen,this.cachedItemsLen=this.screenItemsLen+2*this.offsetItems,this._renderChunk(this.container,0);var s=this;s.lastRepaintY=0;this.screenItemsLen;function r(e){var t=e.target.scrollTop;if(!s.lastRepaintY||Math.abs(t-s.lastRepaintY)>=s.offsetItems*s.itemHeight){var n=parseInt(t/o,10)-s.offsetItems;s._renderChunk(s.container,n<0?0:n),s.lastRepaintY=t}s.lastScrolled=Date.now(),null!=s.scrollFn&&s.scrollFn(),e.preventDefault&&e.preventDefault()}s.dispose=function(){s.container&&s.container.parentNode&&s.container.parentNode.removeChild(s.container),s.container.removeEventListener("scroll",r)},s.container.addEventListener("scroll",r)}return e.prototype.reset=function(e){this.screenItemsLen=Math.ceil(e/this.itemHeight),this.cachedItemsLen=this.screenItemsLen+2*this.offsetItems;var t=parseInt(this.lastRepaintY/this.itemHeight,10)-this.offsetItems;this.needReset=!0,this._renderChunk(this.container,Math.max(t,0))},e.prototype.createRow=function(e){var t;return this.generatorFn&&((t=this.generatorFn(e)).classList.add("df-vrow"),t.style.position="absolute",t.style.top=e*this.itemHeight+"px",t.setAttribute("index",e)),t},e.prototype._renderChunk=function(e,t){var n=null==this.range;this.range=this.range||{min:0,max:this.cachedItemsLen};var i=this.range,o=i.min,a=i.max,s=!!n||t>=o;if(n||t!=o||0!=this.needReset){var r,l=n?o:s?a:t;l=l>this.totalRows?this.totalRows:l<0?0:l;var c=t+this.cachedItemsLen;for(c=c>this.totalRows?this.totalRows:c,r=l;r<c;r++)s?e.appendChild(this.createRow(r)):e.insertBefore(this.createRow(r),e.childNodes[1+r-l]),null!=this.addFn&&this.addFn(r);Math.abs(t-o);if(this.needReset=!1,!n&&e.childNodes.length>this.cachedItemsLen+1)for(var d=s?1:1+this.cachedItemsLen,u=d+(c-l);u>d;u--)e.childNodes[d]&&this.container.removeChild(e.childNodes[d]);this.range.min=t,this.range.max=c}},e.createContainer=function(e,t){var n=document.createElement("div");return n.style.width=e,n.style.height=t,n.style.overflow="auto",n.style.position="relative",n.style.padding=0,n},e.createScroller=function(e){var t=document.createElement("div");return t.style.opacity=0,t.style.position="absolute",t.style.top=0,t.style.left=0,t.style.width="1px",t.style.height=e+"px",t},e}(),BookMarkViewer=function(){function e(e){this.outline=null,this.lastToggleIsShow=!0,this.container=e.container,this.linkService=e.linkService,this.outlineItemClass=e.outlineItemClass||"outlineItem",this.outlineToggleClass=e.outlineToggleClass||"outlineItemToggler",this.outlineToggleHiddenClass=e.outlineToggleHiddenClass||"outlineItemsHidden"}return e.prototype={dispose:function(){this.container&&this.container.parentNode&&this.container.parentNode.removeChild(this.container),this.linkService=null},reset:function(){this.outline=null,this.lastToggleIsShow=!0;for(var e=this.container;e.firstChild;)e.removeChild(e.firstChild)},_dispatchEvent:function(e){var t=document.createEvent("CustomEvent");t.initCustomEvent("outlineloaded",!0,!0,{outlineCount:e}),this.container.dispatchEvent(t)},_bindLink:function(e,t){var n=this.linkService;if(1==t.custom)e.href=n.getCustomDestinationHash(t.dest),e.onclick=function(e){return n.customNavigateTo(t.dest),!1};else{if(t.url)return void pdfjsLib.addLinkAttributes(e,{url:t.url});e.href=n.getDestinationHash(t.dest),e.onclick=function(e){return n.navigateTo(t.dest),!1}}},_addToggleButton:function(e){var t=document.createElement("div");t.className=this.outlineToggleClass+" "+this.outlineToggleHiddenClass,t.onclick=function(n){if(n.stopPropagation(),t.classList.toggle(this.outlineToggleHiddenClass),n.shiftKey){var i=!t.classList.contains(this.outlineToggleHiddenClass);this._toggleOutlineItem(e,i)}}.bind(this),e.insertBefore(t,e.firstChild)},_toggleOutlineItem:function(e,t){this.lastToggleIsShow=t;for(var n=e.querySelectorAll("."+this.outlineToggleClass),i=0,o=n.length;i<o;++i)n[i].classList[t?"remove":"add"](this.outlineToggleHiddenClass)},toggleOutlineTree:function(){this.outline&&this._toggleOutlineItem(this.container,!this.lastToggleIsShow)},render:function(e){var t=e&&e.outline||null,n=0;if(this.outline&&this.reset(),this.outline=t,t){for(var i=document.createDocumentFragment(),o=[{parent:i,items:this.outline}],a=!1;o.length>0;)for(var s=o.shift(),r=s.custom,l=0,c=s.items.length;l<c;l++){var d=s.items[l],u=document.createElement("div");u.className=this.outlineItemClass;var h=document.createElement("a");if(null==d.custom&&null!=r&&(d.custom=r),this._bindLink(h,d),h.textContent=d.title.replace(/\x00/g,""),u.appendChild(h),d.items&&d.items.length>0){a=!0,this._addToggleButton(u);var p=document.createElement("div");p.className=this.outlineItemClass+"s",u.appendChild(p),o.push({parent:p,custom:d.custom,items:d.items})}s.parent.appendChild(u),n++}a&&(null!=this.container.classList?this.container.classList.add(this.outlineItemClass+"s"):null!=this.container.className&&(this.container.className+=" picWindow")),this.container.appendChild(i),this._dispatchEvent(n)}}},e}(),DFLightBox=function(e){function t(t,n){this.duration=300;var i=this;return i.lightboxWrapper=e("<div>").addClass("df-lightbox-wrapper"),i.container=e("<div>").addClass("df-container").appendTo(i.lightboxWrapper),i.controls=e("<div>").addClass("df-lightbox-controls").appendTo(i.lightboxWrapper),i.closeButton=e("<div>").addClass("df-lightbox-close df-ui-btn").on("click",(function(){i.close(t)})).appendTo(i.controls),i.lightboxWrapper.append(i.container),i}return t.prototype.show=function(t){return 0==this.lightboxWrapper.parent().length&&e("body").append(this.lightboxWrapper),e("html,body").addClass("df-lightbox-open"),this.lightboxWrapper.fadeIn(this.duration,t),this},t.prototype.close=function(t){return this.lightboxWrapper.fadeOut(this.duration),setTimeout(t,this.duration),e("html,body").removeClass("df-lightbox-open"),this},t}(jQuery);DFLIP.Share=function(e){function t(t,n){var i=this,o="<div>",a="width=500,height=400";i.isOpen=!1,i.shareUrl="",i.wrapper=e('<div class="df-share-wrapper" style="display: none;">').on("click",(function(e){i.close()})),i.box=e('<div class="df-share-box">').on("click",(function(e){e.preventDefault(),e.stopPropagation()})).appendTo(i.wrapper).html('<span class="df-share-title">'+n.text.share+"</span>"),i.urlInput=e('<textarea class="df-share-url">').on("click",(function(){e(this).select()})),i.facebook=e(o,{class:"df-share-button df-share-facebook "+n.icons.facebook}).on("click",(function(e){window.open("https://www.facebook.com/sharer/sharer.php?u="+encodeURIComponent(i.shareUrl),"Sharer",a)})),i.google=e(o,{class:"df-share-button df-share-google "+n.icons.google}).on("click",(function(e){window.open("https://plus.google.com/share?url="+encodeURIComponent(i.shareUrl),"Sharer",a)})),i.twitter=e(o,{class:"df-share-button df-share-twitter "+n.icons.twitter}).on("click",(function(e){window.open("http://twitter.com/share?url="+encodeURIComponent(i.shareUrl),"Sharer",a)})),i.mail=e("<a>",{class:"df-share-button df-share-mail "+n.icons.mail,href:"mailto:?subject="+n.text.mailSubject+"&body="+n.text.mailBody.replace("{{url}}",encodeURIComponent(i.shareUrl)),target:"_blank"}).on("click",(function(t){e(this).attr("href","mailto:?subject="+n.text.mailSubject+"&body="+n.text.mailBody.replace("{{url}}",encodeURIComponent(i.shareUrl))),t.stopPropagation()})),i.box.append(i.urlInput).append(i.facebook).append(i.twitter).append(i.mail),e(t).append(i.wrapper)}return t.prototype.show=function(){this.wrapper.fadeIn(300),this.urlInput.val(this.shareUrl),this.urlInput.trigger("click"),this.isOpen=!0},t.prototype.dispose=function(){var e=this;e.box.off(),e.google.off(),e.twitter.off(),e.facebook.off(),e.mail.off(),e.urlInput.off(),e.wrapper.off().remove()},t.prototype.close=function(){this.wrapper.fadeOut(300),this.isOpen=!1},t.prototype.update=function(e){this.shareUrl=e},t}(jQuery),DFLIP.Popup=function(e){function t(t,n){var i=this;i.isOpen=!1,i.wrapper=e('<div class="df-popup-wrapper" style="display: none;">').on("click",(function(e){i.close()})),i.box=e('<div class="df-popup-box">').on("click",(function(e){e.preventDefault(),e.stopPropagation()})).appendTo(i.wrapper),e(t).append(i.wrapper)}return t.prototype.show=function(){this.wrapper.fadeIn(300),this.isOpen=!0},t.prototype.dispose=function(){this.box.off(),this.wrapper.off().remove()},t.prototype.close=function(){this.wrapper.fadeOut(300),this.isOpen=!1},t}(jQuery);var PDFLinkService=function(){function e(){this.baseUrl=null,this.pdfDocument=null,this.pdfViewer=null,this.pdfHistory=null,this._pagesRefCache=null}return e.prototype={dispose:function(){this.baseUrl=null,this.pdfDocument=null,this.pdfViewer=null,this.pdfHistory=null,this._pagesRefCache=null},setDocument:function(e,t){this.baseUrl=t,this.pdfDocument=e,this._pagesRefCache=Object.create(null)},setViewer:function(e){this.pdfViewer=e,this.externalLinkTarget=e.previewObject.options.linkTarget},setHistory:function(e){this.pdfHistory=e},get pagesCount(){return this.pdfDocument.numPages},get page(){return this.pdfViewer.currentPageNumber},set page(e){this.pdfViewer.currentPageNumber=e},navigateTo:function(e){this.goToDestination(e)},goToDestination:function(e){var t,n="",i=this,o=function(t){var a=t instanceof Object?i._pagesRefCache[t.num+" "+t.gen+" R"]:t+1;a?(i.pdfViewer.contentProvider.options.pageSize==DFLIP.PAGE_SIZE.DOUBLEINTERNAL&&a>2&&(a=2*a-1),a>i.pdfViewer.pageCount&&(a=i.pdfViewer.pageCount),i.pdfViewer.gotoPage(a),i.pdfHistory&&i.pdfHistory.push({dest:e,hash:n,page:a})):i.pdfDocument.getPageIndex(t).then((function(e){var n=e+1,a=t.num+" "+t.gen+" R";i._pagesRefCache[a]=n,o(t)}))};"string"==typeof e?(n=e,t=this.pdfDocument.getDestination(e)):t=Promise.resolve(e),t.then((function(t){e=t,t instanceof Array&&o(t[0])}))},customNavigateTo:function(e){if(""!=e&&null!=e&&"null"!=e){var t=null;if(isNaN(Math.round(e))){if("string"==typeof e&&(t=parseInt(e.replace("#",""),10),isNaN(t)))return void window.open(e,DFLIP.defaults.linkTarget==DFLIP.LINK_TARGET.SELF?"_self":"_blank")}else t=e;null!=t&&this.pdfViewer.gotoPage(t)}},getDestinationHash:function(e){if("string"==typeof e)return this.getAnchorUrl("#"+escape(e));if(e instanceof Array){var t=e[0],n=t instanceof Object?this._pagesRefCache[t.num+" "+t.gen+" R"]:t+1;if(n){var i=this.getAnchorUrl("#page="+n),o=e[1];if("object"==typeof o&&"name"in o&&"XYZ"===o.name){var a=e[4]||this.pdfViewer.currentScaleValue,s=parseFloat(a);s&&(a=100*s),i+="&zoom="+a,(e[2]||e[3])&&(i+=","+(e[2]||0)+","+(e[3]||0))}return i}}return this.getAnchorUrl("")},getCustomDestinationHash:function(e){return"#"+escape(e)},getAnchorUrl:function(e){return(this.baseUrl||"")+e},setHash:function(e){if(e.indexOf("=")>=0){var t,n,i=parseQueryString(e);if("nameddest"in i)return this.pdfHistory&&this.pdfHistory.updateNextHashParam(i.nameddest),void this.navigateTo(i.nameddest);if("page"in i&&(t=0|i.page||1),"zoom"in i){var o=i.zoom.split(","),a=o[0],s=parseFloat(a);-1===a.indexOf("Fit")?n=[null,{name:"XYZ"},o.length>1?0|o[1]:null,o.length>2?0|o[2]:null,s?s/100:a]:"Fit"===a||"FitB"===a?n=[null,{name:a}]:"FitH"===a||"FitBH"===a||"FitV"===a||"FitBV"===a?n=[null,{name:a},o.length>1?0|o[1]:null]:"FitR"===a?5!==o.length?console.error("PDFLinkService_setHash: Not enough parameters for 'FitR'."):n=[null,{name:a},0|o[1],0|o[2],0|o[3],0|o[4]]:console.error("PDFLinkService_setHash: '"+a+"' is not a valid zoom value.")}if(n?this.pdfViewer.scrollPageIntoView(t||this.page,n):t&&(this.page=t),"pagemode"in i){var r=document.createEvent("CustomEvent");r.initCustomEvent("pagemode",!0,!0,{mode:i.pagemode}),this.pdfViewer.container.dispatchEvent(r)}}else/^\d+$/.test(e)?this.page=e:(this.pdfHistory&&this.pdfHistory.updateNextHashParam(unescape(e)),this.navigateTo(unescape(e)))},executeNamedAction:function(e){switch(e){case"GoBack":this.pdfHistory&&this.pdfHistory.back();break;case"GoForward":this.pdfHistory&&this.pdfHistory.forward();break;case"NextPage":this.page++;break;case"PrevPage":this.page--;break;case"LastPage":this.page=this.pagesCount;break;case"FirstPage":this.page=1}var t=document.createEvent("CustomEvent");t.initCustomEvent("namedaction",!0,!0,{action:e}),this.pdfViewer.container.dispatchEvent(t)},cachePageRef:function(e,t){var n=t.num+" "+t.gen+" R";this._pagesRefCache[n]=e}},e}(),FindStates={FIND_FOUND:0,FIND_NOTFOUND:1,FIND_WRAPPED:2,FIND_PENDING:3},FIND_SCROLL_OFFSET_TOP=-50,FIND_SCROLL_OFFSET_LEFT=-400,CHARACTERS_TO_NORMALIZE={"‘":"'","’":"'","‚":"'","‛":"'","“":'"',"”":'"',"„":'"',"‟":'"',"¼":"1/4","½":"1/2","¾":"3/4"};DFLIP.PDFFindController=function(){function e(e){this.pdfViewer=e.pdfViewer||null,this.onUpdateResultsCount=null,this.onUpdateState=null,this.reset();var t=Object.keys(CHARACTERS_TO_NORMALIZE).join("");this.normalizationRegex=new RegExp("["+t+"]","g")}return e.prototype={reset:function(){this.startedTextExtraction=!1,this.extractTextPromises=[],this.pendingFindMatches=Object.create(null),this.active=!1,this.pageContents=[],this.pageMatches=[],this.pageMatchesLength=null,this.matchCount=0,this.selected={pageIdx:-1,matchIdx:-1},this.offset={pageIdx:null,matchIdx:null},this.pagesToSearch=null,this.resumePageIdx=null,this.state=null,this.dirtyMatch=!1,this.findTimeout=null,this.firstPagePromise=new Promise(function(e){this.resolveFirstPage=e}.bind(this))},normalize:function(e){return e.replace(this.normalizationRegex,(function(e){return CHARACTERS_TO_NORMALIZE[e]}))},_prepareMatches:function(e,t,n){function i(e,t){var n,i,o;if(n=e[t],o=e[t+1],t<e.length-1&&n.match===o.match)return n.skipped=!0,!0;for(var a=t-1;a>=0;a--)if(!(i=e[a]).skipped){if(i.match+i.matchLength<n.match)break;if(i.match+i.matchLength>=n.match+n.matchLength)return n.skipped=!0,!0}return!1}var o,a;for(e.sort((function(e,t){return e.match===t.match?e.matchLength-t.matchLength:e.match-t.match})),o=0,a=e.length;o<a;o++)i(e,o)||(t.push(e[o].match),n.push(e[o].matchLength))},calcFindPhraseMatch:function(e,t,n){for(var i=[],o=e.length,a=-o;-1!==(a=n.indexOf(e,a+o));)i.push(a);this.pageMatches[t]=i},calcFindWordMatch:function(e,t,n){for(var i,o,a,s=[],r=e.match(/\S+/g),l=0,c=r.length;l<c;l++)for(a=-(o=(i=r[l]).length);-1!==(a=n.indexOf(i,a+o));)s.push({match:a,matchLength:o,skipped:!1});this.pageMatchesLength||(this.pageMatchesLength=[]),this.pageMatchesLength[t]=[],this.pageMatches[t]=[],this._prepareMatches(s,this.pageMatches[t],this.pageMatchesLength[t])},calcFindMatch:function(e){var t=this.normalize(this.pageContents[e]),n=this.normalize(this.state.query),i=this.state.caseSensitive,o=this.state.phraseSearch;0!==n.length&&(i||(t=t.toLowerCase(),n=n.toLowerCase()),o?this.calcFindPhraseMatch(n,e,t):this.calcFindWordMatch(n,e,t),this.updatePage(e),this.resumePageIdx===e&&(this.resumePageIdx=null,this.nextPageMatch()),this.pageMatches[e].length>0&&(this.matchCount+=this.pageMatches[e].length,this.updateUIResultsCount()))},extractText:function(){if(!this.startedTextExtraction){this.startedTextExtraction=!0,this.pageContents=[];for(var e=[],t=this.pdfViewer.contentProvider.pdfDocument.numPages,n=0;n<t;n++)this.extractTextPromises.push(new Promise((function(t){e.push(t)})));var i=this;!function t(n){i.pdfViewer.getPageTextContent(n).then((function(o){for(var a=o.items,s=[],r=0,l=a.length;r<l;r++)s.push(a[r].str);i.pageContents.push(s.join("")),e[n](n),console.log("extracting Page"+n),n+1<i.pdfViewer.contentProvider.pdfDocument.numPages&&t(n+1)}))}(0)}},executeCommand:function(e,t){null!==this.state&&"findagain"===e||(this.dirtyMatch=!0),this.state=t,this.updateUIState(FindStates.FIND_PENDING),this.firstPagePromise.then(function(){this.extractText(),clearTimeout(this.findTimeout),"find"===e?this.findTimeout=setTimeout(this.nextMatch.bind(this),250):this.nextMatch()}.bind(this))},updatePage:function(e){this.selected.pageIdx===e&&(this.pdfViewer.currentPageNumber=e+1);var t=this.pdfViewer.getPageView(e);t.textLayer&&t.textLayer.updateMatches()},nextMatch:function(){var e=this.state.findPrevious,t=this.pdfViewer.currentPageNumber-1,n=this.pdfViewer.contentProvider.pageCount;if(this.active=!0,this.dirtyMatch){this.dirtyMatch=!1,this.selected.pageIdx=this.selected.matchIdx=-1,this.offset.pageIdx=t,this.offset.matchIdx=null,this.hadMatch=!1,this.resumePageIdx=null,this.pageMatches=[],this.matchCount=0,this.pageMatchesLength=null;for(var i=this,o=0;o<n;o++)this.updatePage(o),o in this.pendingFindMatches||(this.pendingFindMatches[o]=!0,this.extractTextPromises[o].then((function(e){delete i.pendingFindMatches[e],i.calcFindMatch(e)})))}if(""!==this.state.query){if(!this.resumePageIdx){var a=this.offset;if(this.pagesToSearch=n,null!==a.matchIdx){var s=this.pageMatches[a.pageIdx].length;if(!e&&a.matchIdx+1<s||e&&a.matchIdx>0)return this.hadMatch=!0,a.matchIdx=e?a.matchIdx-1:a.matchIdx+1,void this.updateMatch(!0);this.advanceOffsetPage(e)}this.nextPageMatch()}}else this.updateUIState(FindStates.FIND_FOUND)},matchesReady:function(e){var t=this.offset,n=e.length,i=this.state.findPrevious;return n?(this.hadMatch=!0,t.matchIdx=i?n-1:0,this.updateMatch(!0),!0):(this.advanceOffsetPage(i),!!(t.wrapped&&(t.matchIdx=null,this.pagesToSearch<0))&&(this.updateMatch(!1),!0))},updateMatchPosition:function(e,t,n,i){if(this.selected.matchIdx===t&&this.selected.pageIdx===e){var o={top:FIND_SCROLL_OFFSET_TOP,left:FIND_SCROLL_OFFSET_LEFT};scrollIntoView(n[i],o,!0)}},nextPageMatch:function(){null!==this.resumePageIdx&&console.error("There can only be one pending page.");do{var e=this.offset.pageIdx,t=this.pageMatches[e];if(!t){this.resumePageIdx=e;break}}while(!this.matchesReady(t))},advanceOffsetPage:function(e){var t=this.offset,n=this.extractTextPromises.length;t.pageIdx=e?t.pageIdx-1:t.pageIdx+1,t.matchIdx=null,this.pagesToSearch--,(t.pageIdx>=n||t.pageIdx<0)&&(t.pageIdx=e?n-1:0,t.wrapped=!0)},updateMatch:function(e){var t=FindStates.FIND_NOTFOUND,n=this.offset.wrapped;if(this.offset.wrapped=!1,e){var i=this.selected.pageIdx;this.selected.pageIdx=this.offset.pageIdx,this.selected.matchIdx=this.offset.matchIdx,t=n?FindStates.FIND_WRAPPED:FindStates.FIND_FOUND,-1!==i&&i!==this.selected.pageIdx&&this.updatePage(i)}this.updateUIState(t,this.state.findPrevious),-1!==this.selected.pageIdx&&this.updatePage(this.selected.pageIdx)},updateUIResultsCount:function(){this.onUpdateResultsCount&&this.onUpdateResultsCount(this.matchCount)},updateUIState:function(e,t){this.onUpdateState&&this.onUpdateState(e,t,this.matchCount)}},e}(),DFLIP.TextLayerBuilder=function(){function e(e){this.textLayerDiv=e.textLayerDiv,this.renderingDone=!1,this.divContentDone=!1,this.pageIdx=e.pageIndex,this.pageNumber=this.pageIdx+1,this.matches=[],this.viewport=e.viewport,this.textDivs=[],this.findController=e.findController||null,this.textLayerRenderTask=null,this.enhanceTextSelection=e.enhanceTextSelection,this._bindMouse()}return e.prototype={_finishRendering:function(){if(this.renderingDone=!0,!this.enhanceTextSelection){var e=document.createElement("div");e.className="endOfContent",this.textLayerDiv.appendChild(e)}},render:function(e){if(this.divContentDone&&!this.renderingDone){this.textLayerRenderTask&&(this.textLayerRenderTask.cancel(),this.textLayerRenderTask=null),this.textDivs=[];var t=document.createDocumentFragment();this.textLayerRenderTask=pdfjsLib.renderTextLayer({textContent:this.textContent,container:t,viewport:this.viewport,textDivs:this.textDivs,timeout:e,enhanceTextSelection:this.enhanceTextSelection}),this.textLayerRenderTask.promise.then(function(){this.textLayerDiv.appendChild(t),this._finishRendering(),this.updateMatches()}.bind(this),(function(e){}))}},setTextContent:function(e){this.textLayerRenderTask&&(this.textLayerRenderTask.cancel(),this.textLayerRenderTask=null),this.textContent=e,this.divContentDone=!0},convertMatches:function(e,t){var n=0,i=0,o=this.textContent.items,a=o.length-1,s=null===this.findController?0:this.findController.state.query.length,r=[];if(!e)return r;for(var l=0,c=e.length;l<c;l++){for(var d=e[l];n!==a&&d>=i+o[n].str.length;)i+=o[n].str.length,n++;n===o.length&&console.error("Could not find a matching mapping");var u={begin:{divIdx:n,offset:d-i}};for(d+=t?t[l]:s;n!==a&&d>i+o[n].str.length;)i+=o[n].str.length,n++;u.end={divIdx:n,offset:d-i},r.push(u)}return r},renderMatches:function(e){if(0!==e.length){var t=this.textContent.items,n=this.textDivs,i=null,o=this.pageIdx,a=null!==this.findController&&o===this.findController.selected.pageIdx,s=null===this.findController?-1:this.findController.selected.matchIdx,r={divIdx:-1,offset:void 0},l=s,c=l+1;if(null!==this.findController&&this.findController.state.highlightAll)l=0,c=e.length;else if(!a)return;for(var d=l;d<c;d++){var u=e[d],h=u.begin,p=u.end,g=a&&d===s?" selected":"";if(this.findController&&this.findController.updateMatchPosition(o,d,n,h.divIdx),i&&h.divIdx===i.divIdx?b(i.divIdx,i.offset,h.offset):(null!==i&&b(i.divIdx,i.offset,r.offset),v(h)),h.divIdx===p.divIdx)b(h.divIdx,h.offset,p.offset,"highlight"+g);else{b(h.divIdx,h.offset,r.offset,"highlight begin"+g);for(var f=h.divIdx+1,m=p.divIdx;f<m;f++)n[f].className="highlight middle"+g;v(p,"highlight end"+g)}i=p}i&&b(i.divIdx,i.offset,r.offset)}function v(e,t){var i=e.divIdx;n[i].textContent="",b(i,0,e.offset,t)}function b(e,i,o,a){var s=n[e],r=t[e].str.substring(i,o),l=document.createTextNode(r);if(a){var c=document.createElement("span");return c.className=a,c.appendChild(l),void s.appendChild(c)}s.appendChild(l)}},updateMatches:function(){if(this.renderingDone){for(var e,t,n=this.matches,i=this.textDivs,o=this.textContent.items,a=-1,s=0,r=n.length;s<r;s++){for(var l=n[s],c=Math.max(a,l.begin.divIdx),d=l.end.divIdx;c<=d;c++){var u=i[c];u.textContent=o[c].str,u.className=""}a=l.end.divIdx+1}if(null!==this.findController&&this.findController.active)null!==this.findController&&(e=this.findController.pageMatches[this.pageIdx]||null,t=this.findController.pageMatchesLength&&this.findController.pageMatchesLength[this.pageIdx]||null),this.matches=this.convertMatches(e,t),this.renderMatches(this.matches)}},_bindMouse:function(){var e=this.textLayerDiv,t=this;e.addEventListener("mousedown",(function(n){if(t.enhanceTextSelection&&t.textLayerRenderTask)t.textLayerRenderTask.expandTextDivs(!0);else{var i=e.querySelector(".endOfContent");if(i){var o=n.target!==e;if(o=o&&"none"!==window.getComputedStyle(i).getPropertyValue("-moz-user-select")){var a=e.getBoundingClientRect(),s=Math.max(0,(n.pageY-a.top)/a.height);i.style.top=(100*s).toFixed(2)+"%"}i.classList.add("active")}}})),e.addEventListener("mouseup",(function(n){if(t.enhanceTextSelection&&t.textLayerRenderTask)t.textLayerRenderTask.expandTextDivs(!1);else{var i=e.querySelector(".endOfContent");i&&(i.style.top="",i.classList.remove("active"))}}))}},e}(),DFLIP.ConvertPageLinks=function(){for(var e,t=arguments[0]/100,n=arguments[1]/100,i=function(e,i,o,a,s){return{x:e/t,y:i/n,w:o/t,h:a/n,dest:s}},o=[],a=2;a<arguments.length;a++)e=arguments[a],o[a-2]=i.apply(this,e);return o},DFLIP.parseLinks=function(e){var t;if(null!=e&&e.length>0)for(var n=0;n<e.length;n++)null!=(t=e[n])&&null!=t[0]&&null==t[0].dest&&(t=DFLIP.ConvertPageLinks.apply(this,t),e[n]=t);return e},function(e){function t(e){return"true"==e||1==e}function n(e){null!=e.webgl&&(e.webgl=t(e.webgl)),null!=e.enableDownload&&(e.enableDownload=t(e.enableDownload)),null!=e.search&&(e.search=t(e.search)),null!=e.enableAnalytics&&(e.enableAnalytics=t(e.enableAnalytics)),null!=e.scrollWheel&&(e.scrollWheel=t(e.scrollWheel)),null!=e.autoEnableOutline&&(e.autoEnableOutline=t(e.autoEnableOutline)),null!=e.autoEnableThumbnail&&(e.autoEnableThumbnail=t(e.autoEnableThumbnail)),null!=e.transparent&&(e.transparent=t(e.transparent)),null!=e.overwritePDFOutline&&(e.overwritePDFOutline=t(e.overwritePDFOutline)),null!=e.soundEnable&&(e.soundEnable=t(e.soundEnable)),null!=e.forceFit&&(e.forceFit=t(e.forceFit)),null!=e.enableAnnotation&&(e.enableAnnotation=t(e.enableAnnotation)),null!=e.webglShadow&&(e.webglShadow=t(e.webglShadow)),null!=e.autoPlay&&(e.autoPlay=t(e.autoPlay)),null!=e.autoPlayStart&&(e.autoPlayStart=t(e.autoPlayStart)),null!=e.paddingTop&&(e.paddingTop=parseInt(e.paddingTop,10)),null!=e.paddingRight&&(e.paddingRight=parseInt(e.paddingRight,10)),null!=e.paddingBottom&&(e.paddingBottom=parseInt(e.paddingBottom,10)),null!=e.paddingLeft&&(e.paddingLeft=parseInt(e.paddingLeft,10)),null!=e.zoomRatio&&(e.zoomRatio=parseFloat(e.zoomRatio,10)),null!=e.stiffness&&(e.stiffness=parseFloat(e.stiffness,10)),null!=e.autoPlayDuration&&(e.autoPlayDuration=parseInt(e.autoPlayDuration,10)),null!=e.linkTarget&&(e.linkTarget=parseInt(e.linkTarget,10)),0!=e.pageMode&&"0"!=e.pageMode||(e.pageMode=null),0!=e.singlePageMode&&"0"!=e.singlePageMode||(e.singlePageMode=null)}DFLIP.getOptions=function(t){var i="option_"+(t=e(t)).attr("id"),o=t.attr("source")||t.attr("df-source");(i=null==i||""==i||null==window[i]?{}:window[i]).source=null==o||""==o?i.source:o;var a={webgl:t.attr("webgl"),height:t.attr("height"),soundEnable:t.attr("sound"),bookTitle:t.data("title"),transparent:t.attr("transparent"),enableDownload:t.attr("download"),search:t.attr("search"),duration:t.attr("duration"),hard:t.attr("hard"),openPage:t.data("page"),pageMode:t.attr("pagemode"),direction:t.attr("direction"),backgroundColor:t.attr("backgroundcolor"),scrollWheel:t.attr("scrollwheel"),backgroundImage:t.attr("backgroundimage"),paddingTop:t.attr("paddingtop"),paddingRight:t.attr("paddingright"),paddingBottom:t.attr("paddingbottom"),paddingLeft:t.attr("paddingleft"),wpOptions:t.attr("wpoptions")};return function(e){if(1!=e.parsed){e.parsed=!0;var t=[];if(n(e),"undefined"!=typeof dFlipWPGlobal&&"true"==e.wpOptions){try{for(var i in e.links){for(var o=e.links[i],a=[100,100],s=0;s<o.length;s++){for(var r=o[s].substr(1).slice(0,-1).split(","),l=[],c=0;c<5;c++)l[c]=r[c];a.push(l)}t[parseInt(i,10)+1]=a}}catch(e){console.error(e.stack)}e.links=DFLIP.parseLinks(t)}else e.links=DFLIP.parseLinks(e.links)}}(i=e.extend(!0,{},i,a)),i},DFLIP.parseBooks=function(){e(".dflip-books").each((function(){if(!1!==DFLIP.defaults.loadMoreCount){var t=e(this);if("true"!==(t.attr("parsed")||t.attr("df-parsed"))){t.attr("df-parsed","true");var n=0,i=t.find("._df_button, ._df_thumb, ._df_custom, ._df_book"),o=i.length;i.each((function(){++n>DFLIP.defaults.loadMoreCount&&e(this).attr("skip-parse","true")})),o>DFLIP.defaults.loadMoreCount&&t.append("<div class='df-more-button-wrapper'><div class='df-more-button'>Load More..</div></div>")}}})),e("._df_button, ._df_thumb, ._df_custom, ._df_book").each((function(){var t=e(this);if("true"!==t.attr("skip-parse")&&"true"!==(t.attr("parsed")||t.attr("df-parsed")))if(t.attr("df-parsed","true"),t.hasClass("_df_book")){var n=t.attr("id"),i=t.attr("slug"),o=DFLIP.getOptions(t);o.id=n,null!=i&&(o.slug=i),n?window[n.toString()]=e(t).flipBook(o.source,o):e(t).flipBook(o.source,o)}else if(t.hasClass("_df_thumb")){var a=e("<div class='_df_book-cover'>"),s=t.html().trim();t.html("");e("<span class='_df_book-title'>").html(s).appendTo(a);var r=t.attr("thumb")||t.attr("df-thumb"),l=t.attr("thumbtype")||DFLIP.defaults.thumbElement||"div",c=t.attr("tags")||t.attr("df-tags");if(c&&(c=c.split(",")).length>0)for(var d=0;d<c.length;d++)t.append("<span class='_df_book-tag'>"+c[d]+"</span>");null!=r&&""!=r.toString().trim()?"img"==l?(a.append('<img src="'+r+'" alt="'+s+'"/>'),t.attr("thumb-type","img")):a.css({backgroundImage:"url('"+r+"')"}):a.addClass("_df_thumb-not-found"),t.append(a)}}))},e(document).ready((function(){var t=e("body");"undefined"==typeof dFlipLocation&&0!=DFLIP.autoDetectLocation&&e("script").each((function(){var t=e(this)[0].src;if((t.indexOf("/dflip.js")>-1||t.indexOf("/dflip.min.js")>-1)&&(t.indexOf("https://")>-1||t.indexOf("http://")>-1)&&t.indexOf("js/dflip.")>-1){var n=t.split("/");window.dFlipLocation=n.slice(0,-2).join("/")}})),"undefined"!=typeof dFlipLocation&&(dFlipLocation.length>2&&"/"!==dFlipLocation.slice(-1)&&(window.dFlipLocation+="/"),DFLIP.defaults.mockupjsSrc=dFlipLocation+"js/libs/mockup.min.js",DFLIP.defaults.pdfjsSrc=dFlipLocation+"js/libs/pdf.min.js",DFLIP.defaults.pdfjsCompatibilitySrc=dFlipLocation+"js/libs/compatibility.js",DFLIP.defaults.threejsSrc=dFlipLocation+"js/libs/three.min.js",DFLIP.defaults.pdfjsWorkerSrc=dFlipLocation+"js/libs/pdf.worker.min.js",DFLIP.defaults.soundFile=dFlipLocation+"sound/turn2.mp3",DFLIP.defaults.imagesLocation=dFlipLocation+"images",DFLIP.defaults.imageResourcesPath=dFlipLocation+"images/pdfjs/",DFLIP.defaults.cMapUrl=dFlipLocation+"js/libs/cmaps/","undefined"!=typeof dFlipWPGlobal&&(void 0!==dFlipWPGlobal.pdfVersion&&"default"!==dFlipWPGlobal.pdfVersion&&(DFLIP.defaults.pdfjsSrc=dFlipLocation+"js/libs/pdfjs/"+dFlipWPGlobal.pdfVersion+"/pdf.min.js",DFLIP.defaults.pdfjsWorkerSrc=dFlipLocation+"js/libs/pdfjs/"+dFlipWPGlobal.pdfVersion+"/pdf.worker.min.js"),n(dFlipWPGlobal),e.extend(!0,DFLIP.defaults,dFlipWPGlobal))),DFLIP.preParseHash=window.location.hash,t.on("click","._df_button, ._df_thumb, ._df_custom",(function(t){t.preventDefault();var n=e(this);window.dfLightBox||(window.dfLightBox=new DFLightBox((function(){Array.prototype.forEach.call(DFLIP.utils.getSharePrefixes(),(function(e){0==window.location.hash.indexOf("#"+e)&&(window.location.hash="#_")})),window.dfActiveLightBoxBook.analytics({eventAction:"Book Closed",options:window.dfActiveLightBoxBook.options}),window.dfActiveLightBoxBook.dispose(),window.dfActiveLightBoxBook=null}))),window.dfLightBox.duration=500,window.dfActiveLightBoxBook&&window.dfActiveLightBoxBook.dispose?window.dfActiveLightBoxBook.dispose():window.dfLightBox.show((function(){var t=DFLIP.getOptions(n);t.transparent=!1,t.height="100%",t.id=n.attr("id");var i=n.attr("slug");null!=i&&(t.slug=i),t.isLightBox=!0,window.dfActiveLightBoxBook=e(window.dfLightBox.container).flipBook(t.source,t)}))})),(DFLIP.utils.isSafari||DFLIP.utils.isIOS)&&e("body").addClass("df-webkit");var i=!1;if(Array.prototype.forEach.call(DFLIP.utils.getSharePrefixes(),(function(t){if(DFLIP.preParseHash&&DFLIP.preParseHash.indexOf(t)>=0&&!1===i){var n,o=DFLIP.preParseHash.split(t)[1].split("/")[0],a=DFLIP.preParseHash.split(t)[1].split("/")[1];null!=a&&(a=a.split("/")[0]),0===(n=e("[slug="+o+"]")).length&&(n=e("#"+o)),0===n.length&&(n=e("[_slug="+o+"]")),n.length>0&&(null!=a&&n.data("page",a),n.is("._df_button, ._df_thumb, ._df_custom")&&(n.trigger("click"),i=!0))}})),DFLIP.parseBooks(),t.hasClass("attachment-pdf")){var o=e("[attachment_pdf_flipbook_lightbox]");o.length>0&&e(o[0]).trigger("click")}t.on("click",".df-ui-sidemenu-close",(function(){e(this).closest(".df-container").find(".df-ui-outline.df-active , .df-ui-thumbnail.df-active").trigger("click")})),t.on("mouseout",".annotationDiv section.squareAnnotation",(function(){var t=e(this);DFLIP.handlePopup(t,!1)})),t.on("mouseover",".annotationDiv section.squareAnnotation",(function(){var t=e(this);DFLIP.handlePopup(t,!0)})),DFLIP.handlePopup=function(e,t){void 0===t&&(t=!0);var n=e.closest(".df-container"),i=n.find(".df-comment-popup");if(i.toggleClass("df-active",t),t){var o=e[0].getBoundingClientRect(),a=n[0].getBoundingClientRect(),s=e.find(".popupWrapper").first();i.html(s.html());var r=o.left-a.left;r+360>a.width?r=a.width-360-10:r<10&&(r=10);var l=o.top-a.top+o.height+5;l+i.height()>a.height?l=o.top-i.height()-o.height-10:l<10&&(l=10),i.css({left:r,top:l})}},t.on("click",".dflip-books .df-more-button",(function(){var t=e(this).closest(".dflip-books");if(t.length>0){var n=0;t.find("._df_button, ._df_thumb, ._df_custom, ._df_book").each((function(){"true"===e(this).attr("skip-parse")&&(n<DFLIP.defaults.loadMoreCount&&e(this).removeAttr("skip-parse"),n++)})),DFLIP.parseBooks()}}))}))}(jQuery);