/**
 * @preserve Mockup 1.01 | Copyright 2016, Deepak Ghimire.  All rights reserved.
 */
"use strict";var MOCKUP={VERSION:"1",REVISION:"01"};!function(e){e.__extends=function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n]);function Ctor(){this.constructor=e}return Ctor.prototype=t.prototype,e.prototype=new Ctor,e.__super=t.prototype,e},e.MODE={PLUGIN:0,BUILDER:1},e.GEOMETRY_TYPE={PLANE:0,BOX:1,MODEL:2},e.MATERIAL_FACE={FRONT:4,BACK:5},e.MOUSE={LEFT:0,MIDDLE:1,RIGHT:2},e.Vector3=THREE.Vector3,e.Vector2=THREE.Vector2,e.defaults={anisotropy:8,maxTextureSize:2048,groundTexture:"images/textures/ground-grid.png",textureLoadFallback:"blank"},e.overrideAsTemplate=!1,e.enableLog=!1,e.log=function(){console.log.apply(console,arguments)},e.error=function(){console.error.apply(console,arguments)},e.autoSave=function(){},e.libType="THREE",e.textureLoader=new THREE.TextureLoader,e.paperDefaults={geometryType:e.GEOMETRY_TYPE.PLANE,width:210,height:297,depth:.2,segments:150,widthScale:1,heightScale:1,folds:1,angles:[],backImage:null,frontImage:null,frontBump:null,backBump:null,mipmap:!1,shininess:15,bumpScale:.4,stiffness:.02,color:16777215,skipMaterials:!1,repeat:100,defaultImage:[,,,,"blank","blank"]},e.Paper=function(t){function Paper(t,n){t=jQuery.extend({},e.paperDefaults,t),this.geometryType=t.geometryType,this.width=t.width,this.widthScale=t.widthScale,this.height=t.height,this.depth=t.depth,this.segments=t.segments,this.folds=t.folds,this.angles=t.angles,this._shininess=t.shininess,this._bumpScale=t.bumpScale,this.stiffness=t.stiffness,this.color=t.color,this.heightScale=t.heightScale,this.defaultImage=t.defaultImage,this.baseType="Paper",this.type="Paper",this.subType=t.subType,null!=t.cloneParent&&(this.cloneParent=t.cloneParent),this.createGeometry(),this.updateGeometry(),t.skipMaterials||1==t.skipLoad&&null!=t.cloneParent||(null!=this.frontImage&&null!=t.defaultImage&&this.frontImage(null!=t.frontImage?t.frontImage:t.defaultImage[e.MATERIAL_FACE.FRONT]),null!=this.backImage&&null!=t.defaultImage&&this.backImage(null!=t.backImage?t.backImage:t.defaultImage[e.MATERIAL_FACE.BACK]),null!=this.frontBump&&this.frontBump(t.frontBump),null!=this.backBump&&this.backBump(t.backBump)),null!=this.bumpScale&&this.bumpScale(t.bumpScale),null!=n&&null!=n.add&&n.add(this)}e.__extends(Paper,t);var loadTexture=function(t,n,a,s){if(t){var o=t.image;t.naturalWidth=o.naturalWidth,t.naturalHeight=o.naturalHeight,t.needsUpdate=!0}null!==t&&"map"==a&&(t.anisotropy=0,e.defaults.anisotropy>0&&(t.anisotropy=e.defaults.anisotropy),1==THREE.skipPowerOfTwo&&(t.minFilter=THREE.LinearFilter,t.magFilter=THREE.LinearFilter),t.name=(new Date).toTimeString(),null!=n.textureRepeat&&(t.wrapS=THREE.RepeatWrapping,t.wrapT=THREE.RepeatWrapping,e.defaults.anisotropy>0&&(t.anisotropy=e.defaults.anisotropy),t.repeat.set(n._textureRepeat,n._textureRepeat),n instanceof e.Ground&&(n.material.bumpMap=t,n.material.bumpScale=n.bumpScale(),n.material.needsUpdate=!0))),n.geometryType==e.GEOMETRY_TYPE.PLANE?(clearTexture(n.material[a]),n.material[a]=t,"bumpMap"==a&&(n.material.bumpScale=n.bumpScale())):(clearTexture(n.material.materials[s][a]),n.material.materials[s][a]=t,"bumpMap"==a&&(n.material.materials[s].bumpScale=n.bumpScale()),n.material.materials[s].needsUpdate=!0),e.autoSave()},clearTexture=function(e){e&&(e.image&&"CANVAS"==e.image.nodeName&&(e.image.remove&&e.image.remove(),delete e.image),e.dispose&&e.dispose(),e=null)},traverseStage=function(e){return e instanceof THREE.Object3D&&e.parent instanceof THREE.Object3D?e.parent instanceof THREE.Scene?e.parent:traverseStage(e.parent):null};return e.loadImage=function(t,n,a,s,o){if(null==n){var r=t.geometryType==e.GEOMETRY_TYPE.PLANE?null!==t.material[s]?t.material[s].sourceFile:null:null==t.material.materials[a]?null:t.material.materials[a][s]?t.material.materials[a][s].sourceFile:null;return null==r||r.indexOf("data:image")>-1?null:r}1==e.enableLog&&console.log(n);var i=null;if("CANVAS"==n.nodeName||"IMG"==n.nodeName){(i=new THREE.Texture(n)).needsUpdate=!0,loadTexture(i,t,s,a),null!=o&&o(t,i);var p=traverseStage(t);null!=p&&(p.renderRequestPending=!0)}else"blank"!=n?(i=null==n?null:e.textureLoader.load(n,(function(e){e.sourceFile=n,loadTexture(e,t,s,a),null!=o&&o(t,e);var r=traverseStage(t);null!=r&&(r.renderRequestPending=!0)}),void 0,(function(o){if(null==i.image)if(null!=t.defaultImage){var r=t.geometryType==e.GEOMETRY_TYPE.PLANE?t.defaultImage[e.MATERIAL_FACE.FRONT]:t.defaultImage[a];n!==r&&null!=r?e.loadImage(t,r,a,s):n===e.defaults.textureLoadFallback&&null!=r||e.loadImage(t,e.defaults.textureLoadFallback,a,s)}else n!==e.defaults.textureLoadFallback&&e.loadImage(t,e.defaults.textureLoadFallback,a,s)})))&&(i.mapping=THREE.UVMapping):loadTexture(null,t,s,a);return 0},Paper.prototype.loadImage=function(t,n,a,s){return e.loadImage(this,t,n,a,s)},Paper.prototype.frontImage=function(t,n){return this.loadImage(t,e.MATERIAL_FACE.FRONT,"map",n)},Paper.prototype.backImage=function(t,n){return this.loadImage(t,e.MATERIAL_FACE.BACK,"map",n)},Paper.prototype.frontBump=function(t,n){return this.loadImage(t,e.MATERIAL_FACE.FRONT,"bumpMap",n)},Paper.prototype.backBump=function(t,n){return this.loadImage(t,e.MATERIAL_FACE.BACK,"bumpMap",n)},Paper.prototype.bumpScale=function(t){if(null==t)return this._bumpScale;this._bumpScale=t,this.geometryType==e.GEOMETRY_TYPE.PLANE?this.material.bumpScale=t:this.geometryType==e.GEOMETRY_TYPE.BOX&&(this.material.materials[e.MATERIAL_FACE.FRONT].bumpScale=t,this.material.materials[e.MATERIAL_FACE.BACK].bumpScale=t)},Paper.prototype.shininess=function(t){if(null==t)return this._shininess;this._shininess=t,this.geometryType==e.GEOMETRY_TYPE.PLANE?this.material.shininess=t:this.geometryType==e.GEOMETRY_TYPE.BOX&&(this.material.materials[e.MATERIAL_FACE.FRONT].shininess=t,this.material.materials[e.MATERIAL_FACE.BACK].shininess=t)},Paper.prototype.bumpImage=function(t){return this.loadImage(t,e.MATERIAL_FACE.FRONT,"bumpMap")},Paper.prototype.createCopy=function(t){null==t&&(t={},e.getParameter(this,t)),t.type=this.type;var n=e.createObject(t);return n.cloneParent=null,n.copy(this,null),n},Paper.prototype.createClone=function(t){null==t&&(t={},e.getParameter(this,t)),t.type=this.type;var n=e.createObject(t);return n.material=this.material,n.cloneParent=null!=n.cloneParent?n.cloneParent:this.uuid,n.copy(this,null),n},Paper.prototype.createGeometry=function(){var n={color:this.color,shading:THREE.SmoothShading,shininess:this._shininess},a=new THREE.MeshPhongMaterial(n);if(this.geometryType==e.GEOMETRY_TYPE.BOX){var s=[a,a,a,a,new THREE.MeshPhongMaterial(n),new THREE.MeshPhongMaterial(n)];t.call(this,new THREE.BoxGeometry(this.width,this.height,this.depth,this.segments*this.folds,1,1),new THREE.MeshFaceMaterial(s))}else this.geometryType==e.GEOMETRY_TYPE.PLANE&&t.call(this,new THREE.PlaneBufferGeometry(this.width,this.height),a)},Paper.prototype.updateGeometry=function(){},Paper}(THREE.Mesh)}(MOCKUP||(MOCKUP={})),function(e){e.selected=null,e.Stage=function(t){function Stage(n){n=n||{};var a=this;if(a.postRender=null,t.call(a),!0!==n.skipLoad){a.canvas=n.canvas||document.createElement("canvas"),a.canvas=jQuery(this.canvas),a.camera=new THREE.PerspectiveCamera(30,a.width/a.height,4,5e4),a.renderer=new THREE.WebGLRenderer({canvas:a.canvas[0],antialias:!0,alpha:!0}),a.renderer.setPixelRatio(n.pixelRatio),a.renderer.setSize(a.width,a.height),a.renderer.setClearColor(16777215,0),(a.orbitControl=new THREE.OrbitControls(a.camera,a.renderer.domElement)).maxPolarAngle=Math.PI,e.mode!==e.MODE.PLUGIN&&(a.renderer.shadowMap.enabled=!0,a.ground=new e.Ground({color:15658734,height:a.camera.far,width:a.camera.far},a)),a.ambientLight=new THREE.AmbientLight(4473924),a.add(a.ambientLight);var s=a.spotLight=new THREE.DirectionalLight(16777215,.5);if(s.position.set(0,1,0),0!=n.webglShadow&&(s.castShadow=!0,s.shadow=new THREE.LightShadow(new THREE.PerspectiveCamera(70,1,200,2e3)),s.shadow.bias=-222e-6,s.shadow.mapSize.width=1024,s.shadow.mapSize.height=1024),s.intensity=.6,s.shadow){var o=a.spotLightHelper=new THREE.CameraHelper(s.shadow.camera);o.visible=!1,a.add(s),a.add(o)}if(1==n.stats){var r=a.stats=new Stats;r.domElement.style.position="absolute",r.domElement.style.top="60px",a.canvas.parent().append(jQuery(r.domElement))}a.enableSoftShadow(!1),a.animateCount=0,a.renderCount=0,a.camera.position.set(-300,300,300),a.camera.lookAt(new THREE.Vector3(0,0,0)),a.orbitControl.center.set(0,0,0),a.orbitControl.update(),a.selectiveRendering=!1,a.renderRequestPending=!1,animate()}function animate(){animate&&requestAnimationFrame(animate),(1!=a.selectiveRendering||1==a.selectiveRendering&&1==a.renderRequestPending)&&a.render()}this.type="Stage",a.cancelRAF=function(){cancelAnimationFrame(animate),animate=null}}return e.__extends(Stage,t),Stage.prototype.enableSoftShadow=function(e){if(null!=this.spotLight.shadow){e=null!=e&&e;var t=this.renderer.shadowMap.type;this.renderer.shadowMap.type=THREE.PCFShadowMap;var n=this.spotLight;if(n.shadow.map){if(t==this.renderer.shadowMap.type)return;n.shadow.map.dispose(),n.shadow.map=null}var a=e?4096:1024;n.shadow.mapSize.width=a,n.shadow.mapSize.height=a,n.shadow.bias=e?-875e-8:-5e-5,this.clearMaterials(),this.renderRequestPending=!0}},Stage.prototype.clearMaterials=function(){for(var e=this.children.length-1;e>=0;e--){var t=this.children[e];if(t.baseType&&"Paper"==t.baseType&&t.material)if(null!=t.material.materials)for(var n=0;n<t.material.materials.length;n++)t.material.materials[n].needsUpdate=!0;else t.material.needsUpdate=!0}},Stage.prototype.clearChild=function(){this.spotLight.shadow.map&&(this.spotLight.shadow.map.dispose(),this.spotLight.shadow.map=null),this.spotLight.castShadow=!1,this.clearMaterials();for(var t=this.children.length-1;t>=0;t--){var n=this.children[t];if(n instanceof e.Bundle)for(var a=n.children.length-1;a>=0;a--)e.clearChild(n.children[a]);e.clearChild(n),n=null}this.render()},Stage.prototype.resizeAuto=function(){this.resizeCanvas(this.canvas.parent().width(),this.canvas.parent().height())},Stage.prototype.resizeCanvas=function(e,t){this.renderer.setSize(e,t),this.camera.aspect=e/t,this.camera.updateProjectionMatrix(),this.renderRequestPending=!0,null!=this.resizeCallback&&this.resizeCallback()},Stage.prototype.render=function(){this.animateCount++,this.renderer.render(this,this.camera),null!=this.stats&&this.stats.update(),this.renderRequestPending=!1,null!=this.renderCallback&&this.renderCallback()},Stage.prototype.toJSON=function(){var t={metadata:{version:4.3,type:"Object",generator:"ObjectExporter"}},n={},a={},parseMaterial=function(e){if(null==t.materials&&(t.materials=[]),null==a[e.uuid]){var n=e.toJSON();delete n.metadata,a[e.uuid]=n,t.materials.push(n)}return e.uuid},parseObject=function(a){var s={};if(s.uuid=a.uuid,s.type=a.type,""!==a.name&&(s.name=a.name),"{}"!==JSON.stringify(a.userData)&&(s.userData=a.userData),!0!==a.visible&&(s.visible=a.visible),e.getParameter(a,s),a instanceof THREE.PerspectiveCamera?(s.fov=a.fov,s.aspect=a.aspect,s.near=a.near,s.far=a.far):a instanceof THREE.OrthographicCamera?(s.left=a.left,s.right=a.right,s.top=a.top,s.bottom=a.bottom,s.near=a.near,s.far=a.far):a instanceof THREE.AmbientLight?s.color=a.color.getHex():a instanceof THREE.DirectionalLight?(s.color=a.color.getHex(),s.intensity=a.intensity):a instanceof THREE.PointLight?(s.color=a.color.getHex(),s.intensity=a.intensity,s.distance=a.distance,s.decay=a.decay):a instanceof THREE.SpotLight?(s.radius=a.radius,s.color=a.color.getHex(),s.intensity=a.intensity,s.distance=a.distance,s.angle=a.angle,s.exponent=a.exponent,s.decay=a.decay):a instanceof THREE.Mesh||a instanceof THREE.Line||a instanceof THREE.PointCloud?a instanceof e.Iphone||(s.geometry=function(e){if(null==t.geometries&&(t.geometries=[]),null==n[e.uuid]){var a=e.toJSON();delete a.metadata,n[e.uuid]=a,t.geometries.push(a)}return e.uuid}(a.geometry),s.material=parseMaterial(a.material),a instanceof THREE.Line&&(s.mode=a.mode)):a instanceof THREE.Sprite&&(s.material=parseMaterial(a.material)),s.matrix=a.matrix.toArray(),a.children.length>0){s.children=[];for(var o=0;o<a.children.length;o++){var r=a.children[o];r instanceof THREE.TransformControls||r instanceof THREE.BoxHelper||a instanceof e.Bundle||s.children.push(parseObject(a.children[o]))}}return s};return t.object=parseObject(this),t},Stage.prototype.hasChild=function(){for(var e=this.children,t=!1,n=0;n<this.children.length;n++)if("Paper"==e[n].baseType&&"Ground"!==e[n].type){t=!0;break}return t},Stage}(THREE.Scene),e.getParameter=function(t,n){null!=t.subType&&(n.subType=t.subType),null!=t.height&&(n.height=t.height),null!=t.width&&(n.width=t.width),null!=t.depth&&(n.depth=t.depth),null!=t.radius&&(n.radius=t.radius),null!=t.segments&&(n.segments=t.segments),null!=t.folds&&(n.folds=t.folds),null!=t.angles&&(n.angles=t.angles),null!=t.shininess&&(n.shininess=t.shininess()),null!=t.bumpScale&&(n.bumpScale=t.bumpScale()),null!=t.stiffness&&(n.stiffness=t.stiffness),null!=t.heightScale&&(n.heightScale=t.heightScale),null!=t.widthScale&&(n.widthScale=t.widthScale),null!=t.frontImage&&(n.frontImage=t.frontImage()),null!=t.backImage&&(n.backImage=t.backImage()),null!=t.backBump&&(n.backBump=t.backBump()),null!=t.frontBump&&(n.frontBump=t.frontBump()),null!=t.cloneParent&&(n.cloneParent=t.cloneParent),null!=t.textureRepeat&&(n.textureRepeat=t.textureRepeat()),null!=t.resolutionHeight&&(n.resolutionHeight=t.resolutionHeight),null!=t.resolutionWidth&&(n.resolutionWidth=t.resolutionWidth),null!=t.screenSize&&(n.screenSize=t.screenSize),1==e.overrideAsTemplate&&(e.getDefaultImage(n),null!=n.defaultImage&&(null!=t.frontImage&&(n.frontImage=n.defaultImage[4]),null!=t.backImage&&(n.backImage=n.defaultImage[5])))},e.getDefaultImage=function(t){null==t.defaultImage&&null!=e.presets[t.type]&&null!=e.presets[t.type].options&&(t.defaultImage=e.presets[t.type].options.defaultImage,null!=t.subType&&null!=e.presets[t.type].menu&&null!=e.presets[t.type].menu.subMenu&&null!=e.presets[t.type].menu.subMenu[t.subType]&&null!=e.presets[t.type].menu.subMenu[t.subType].options.defaultImage&&(t.defaultImage=e.presets[t.type].menu.subMenu[t.subType].options.defaultImage))},e.createObject=function(t){null==t.defaultImage&&null!=e.presets&&null!=e.presets[t.type]&&null!=e.presets[t.type].options&&(t.defaultImage=e.presets[t.type].options.defaultImage,null!=t.subType&&null!=e.presets[t.type].menu&&null!=e.presets[t.type].menu.subMenu&&null!=e.presets[t.type].menu.subMenu[t.subType]&&null!=e.presets[t.type].menu.subMenu[t.subType].options.defaultImage&&(t.defaultImage=e.presets[t.type].menu.subMenu[t.subType].options.defaultImage));var n=new e[t.type](t);return null!=t.cloneParent&&(n.cloneParent=t.cloneParent),n}}(MOCKUP||(MOCKUP={})),function(e){var t=function(t){function PlanePaper(n,a){(n=n||{}).geometryType=e.GEOMETRY_TYPE.PLANE,t.call(this,n,a),this.type="PlanePaper"}return e.__extends(PlanePaper,t),PlanePaper.prototype.backImage=null,PlanePaper.prototype.backBump=null,PlanePaper}(e.Paper);e.PlanePaper=t;var n=function(t){function BoxPaper(n,a){(n=n||{}).geometryType=e.GEOMETRY_TYPE.BOX,t.call(this,n,a),this.type="BoxPaper",this.castShadow=!0,this.receiveShadow=!0}return e.__extends(BoxPaper,t),BoxPaper.prototype.updateGeometry=function(){},BoxPaper}(e.Paper);e.BoxPaper=n;var a=function(t){function FlexBoxPaper(e,n){e=e||{},t.call(this,e,n);for(var a=0;a<6;a++)this.angles[a]=null!=this.angles[a]?this.angles[a]:0;this.updateAngle(),this.type="FoldBoxPaper"}return e.__extends(FlexBoxPaper,t),FlexBoxPaper.prototype.updateGeometry=function(){},FlexBoxPaper.prototype.updateAngle=function(t){var n=this,a=(performance.now(),n.width*(1-Math.sin(n.stiffness/2*(n.stiffness/2))/2)-n.width*n.stiffness/20),s=(n.height,n.segments),o=n.folds,r=n.stiffness,i=a/2,p=a/o,m=p*r,d=p,E=[],f=[],g=[],v=[],M=[],x=[],T=0,y=n.depth,b=(Math.PI,n.angles[4]||0),R=3==o?d/200:0,P=0,w=0,I=[];I.push(w);!function calcPoints(){if(n.folds>=1){M[0]=[],x[o-1]=[],T=n.angles[1]*Math.PI/180,b=n.angles[4]*Math.PI/180;Math.sin(b);M[0][0]=M[0][1]=1==n.folds?new THREE.Vector3(-d*Math.cos(T),0,Math.sin(T)*d):new THREE.Vector3(d-i-d*Math.cos(T),0,Math.sin(T)*d),P=(n.angles[1]-90)*Math.PI/180,T=P,x[o-1][2]=x[o-1][3]=new THREE.Vector3(M[0][0].x-Math.cos(T)*y,0,M[0][0].z+Math.sin(T)*y),1==n.folds&&(M[0][1]=new THREE.Vector3(-d/2*Math.cos(b),0,d/2*Math.sin(b)),x[o-1][2]=new THREE.Vector3(M[0][1].x-Math.cos(P)*y,0,M[0][1].z+Math.sin(P)*y)),T=(45+n.angles[1]/2)*Math.PI/180,n.folds>1&&(T=2==n.folds?(45+n.angles[1]/4-n.angles[4]/2)*Math.PI/180:(45+n.angles[1]/4)*Math.PI/180),M[0][2]=1==n.folds?new THREE.Vector3(-Math.cos(T)*m/2,0,Math.sin(T)*m):new THREE.Vector3(d-i-R-Math.cos(T)*m/2,0,Math.sin(T)*m),x[o-1][1]=1==n.folds?new THREE.Vector3(M[0][2].x-Math.cos(P)*y,0,M[0][2].z+Math.sin(P)*y):M[0][2],M[0][3]=1==n.folds?new THREE.Vector3(0,0,0):new THREE.Vector3(d-i-R,0,0),T=2==n.folds?(n.angles[1]/2-n.angles[4]/2-90)*Math.PI/180:1==n.folds?(n.angles[1]-90)*Math.PI/180:(n.angles[1]/2-90)*Math.PI/180,x[o-1][0]=new THREE.Vector3(M[0][3].x-Math.cos(T)*y,0,M[0][3].z+Math.sin(T)*y)}n.folds>=2&&(M[1]=[],x[o-2]=[],M[1][0]=M[0][3],x[o-2][3]=x[o-1][0],T=(135+3*n.angles[1]/4)*Math.PI/180,M[1][1]=new THREE.Vector3(d-i-Math.cos(T)*m,0,Math.sin(T)*m),x[o-2][2]=M[1][1],T=0,n.folds>2?(T=(45-3*n.angles[4]/4)*Math.PI/180,M[1][2]=new THREE.Vector3(2*d-i+R-Math.cos(T)*m,0,Math.sin(T)*m),x[o-2][1]=M[1][2],M[1][3]=new THREE.Vector3(2*d-i+R,0,0),T=(n.angles[4]/2-90)*Math.PI/180,x[o-2][0]=new THREE.Vector3(M[1][3].x+Math.cos(T)*y*1.25,0,M[1][3].z+Math.sin(T)*y*1.25)):(T=(135-n.angles[4]/4+n.angles[1]/2)*Math.PI/180,M[1][1]=new THREE.Vector3(d-i-Math.cos(T)*m/2,0,Math.sin(T)*m),x[0][2]=M[1][1],T=(180-n.angles[4])*Math.PI/180,M[1][2]=M[1][3]=new THREE.Vector3(d-i-Math.cos(T)*d,0,Math.sin(T)*d),T=(n.angles[4]-90)*Math.PI/180,x[0][0]=x[0][1]=new THREE.Vector3(M[1][3].x+Math.cos(T)*y,0,M[1][3].z+Math.sin(T)*y))),n.folds>2&&(M[2]=[],x[0]=[],M[2][0]=M[1][3],x[0][3]=x[1][0],T=(135-1*n.angles[4]/4)*Math.PI/180,M[2][1]=new THREE.Vector3(2*d-i-0*Math.cos(T),0,Math.sin(T)*m),x[0][2]=M[2][1],T=(180-n.angles[4])*Math.PI/180,M[2][2]=M[2][3]=new THREE.Vector3(2*d-i-Math.cos(T)*d,0,Math.sin(T)*d),T=(n.angles[4]-90)*Math.PI/180,x[0][0]=x[0][1]=new THREE.Vector3(M[2][3].x+Math.cos(T)*y,0,M[2][3].z+Math.sin(T)*y));for(var e=0;e<n.folds;e++){E[e]=new THREE.CubicBezierCurve3(M[e][0],M[e][1],M[e][2],M[e][3]),g[e]=E[e].getPoints(n.segments);for(var t,a=g[e][0],s=1;s<g[e].length;s++)t=g[e][s],w+=t.distanceTo(a),I.push(w),a=t;f[e]=new THREE.CubicBezierCurve3(x[e][0],x[e][1],x[e][2],x[e][3]),v[e]=f[e].getPoints(n.segments)}}();var H=n.geometry,S=o*s+1,z=8;H.vertices[0].z=H.vertices[2].z=H.vertices[z+2*S-1].z=H.vertices[z+3*S-1].z=H.vertices[z+5*S-1].z=H.vertices[z+6*S-1].z=g[o-1][s].z,H.vertices[0].x=H.vertices[2].x=H.vertices[z+2*S-1].x=H.vertices[z+3*S-1].x=H.vertices[z+5*S-1].x=H.vertices[z+6*S-1].x=g[o-1][s].x,H.vertices[1].z=H.vertices[3].z=H.vertices[z+S-1].z=H.vertices[z+4*S-1].z=H.vertices[z+6*S].z=H.vertices[z+7*S].z=v[0][0].z,H.vertices[1].x=H.vertices[3].x=H.vertices[z+S-1].x=H.vertices[z+4*S-1].x=H.vertices[z+6*S].x=H.vertices[z+7*S].x=v[0][0].x,H.vertices[5].z=H.vertices[7].z=H.vertices[z+S].z=H.vertices[z+2*S].z=H.vertices[z+4*S].z=H.vertices[z+5*S].z=g[0][0].z,H.vertices[5].x=H.vertices[7].x=H.vertices[z+S].x=H.vertices[z+2*S].x=H.vertices[z+4*S].x=H.vertices[z+5*S].x=g[0][0].x,H.vertices[4].z=H.vertices[6].z=H.vertices[z].z=H.vertices[z+3*S].z=H.vertices[z+7*S-1].z=H.vertices[z+8*S-1].z=v[o-1][s].z,H.vertices[4].x=H.vertices[6].x=H.vertices[z].x=H.vertices[z+3*S].x=H.vertices[z+7*S-1].x=H.vertices[z+8*S-1].x=v[o-1][s].x;var A=H.vertices.length;z++;for(var C=0;C<o;C++)for(var O=0==C,L=O?s-1:s,B=0;B<L;B++)H.vertices[z].z=H.vertices[z+3*S].z=H.vertices[A-z+7-S].z=H.vertices[A-z+7].z=v[o-1-C][L-B].z,H.vertices[z].x=H.vertices[z+3*S].x=H.vertices[A-z+7-S].x=H.vertices[A-z+7].x=v[o-1-C][L-B].x,H.vertices[z+S].z=H.vertices[z+2*S].z=H.vertices[z+4*S].z=H.vertices[z+5*S].z=g[C][B+O].z,H.vertices[z+S].x=H.vertices[z+2*S].x=H.vertices[z+4*S].x=H.vertices[z+5*S].x=g[C][B+O].x,z++;var V=H.faceVertexUvs[0],k=H.faces,F=0;for(B=0;B<V.length;B++)if(k[B].materialIndex==e.MATERIAL_FACE.FRONT){var _=I[F]/w;B%2==0?(V[B][0].x=V[B][1].x=V[B+1][0].x=_,F++):V[B-1][2].x=V[B][1].x=V[B][2].x=_}else if(k[B].materialIndex==e.MATERIAL_FACE.BACK){_=1-I[F]/w;B%2==0?(V[B][0].x=V[B][1].x=V[B+1][0].x=_,F--):V[B-1][2].x=V[B][1].x=V[B][2].x=_}H.computeBoundingBox();var j=Math.abs(H.boundingBox.min.x-H.boundingBox.max.x),D=Math.abs(H.boundingBox.min.z-H.boundingBox.max.z);Math.sqrt(j*j+D*D);n.scale.x=n.scale.z=d*n.folds/w,H.computeBoundingSphere(),H.verticesNeedUpdate=!0,H.computeFaceNormals(),H.computeVertexNormals(),H.uvsNeedUpdate=!0,H.normalsNeedUpdate=!0,E.forEach((function(e){null})),f.forEach((function(e){null})),v.forEach((function(e){null})),g.forEach((function(e){null}))},FlexBoxPaper}(e.BoxPaper);e.FlexBoxPaper=a;a=function(t){function FlexBoxPaper(e,n){e=e||{},t.call(this,e,n);for(var a=0;a<6;a++)this.angles[a]=null!=this.angles[a]?this.angles[a]:0;this.updateAngle(),this.type="FoldBoxPaper"}return e.__extends(FlexBoxPaper,t),FlexBoxPaper.prototype.updateGeometry=function(){},FlexBoxPaper.prototype.updateAngle=function(t){var n=this,a=(performance.now(),n.width*(1-Math.sin(n.stiffness/2*(n.stiffness/2))/2)-n.width*n.stiffness/20),s=(n.height,n.segments),o=n.folds,r=n.stiffness,i=a/2,p=a/o,m=p*r,d=p,E=[],f=[],g=[],v=[],M=[],x=[],T=0,y=n.depth,b=(Math.PI,n.angles[4]||0),R=3==o?d/200:0,P=0,w=0,I=[];I.push(w);!function calcPoints(){if(n.folds>=1){M[0]=[],x[o-1]=[],T=n.angles[1]*Math.PI/180,b=n.angles[4]*Math.PI/180;Math.sin(b);M[0][0]=M[0][1]=1==n.folds?new THREE.Vector3(-d*Math.cos(T),0,Math.sin(T)*d):new THREE.Vector3(d-i-d*Math.cos(T),0,Math.sin(T)*d),P=(n.angles[1]-90)*Math.PI/180,T=P,x[o-1][2]=x[o-1][3]=new THREE.Vector3(M[0][0].x-Math.cos(T)*y,0,M[0][0].z+Math.sin(T)*y),1==n.folds&&(M[0][1]=new THREE.Vector3(-d/2*Math.cos(b),0,d/2*Math.sin(b)),x[o-1][2]=new THREE.Vector3(M[0][1].x-Math.cos(P)*y,0,M[0][1].z+Math.sin(P)*y)),T=(45+n.angles[1]/2)*Math.PI/180,n.folds>1&&(T=2==n.folds?(45+n.angles[1]/4-n.angles[4]/2)*Math.PI/180:(45+n.angles[1]/4)*Math.PI/180),M[0][2]=1==n.folds?new THREE.Vector3(-Math.cos(T)*m/2,0,Math.sin(T)*m):new THREE.Vector3(d-i-R-Math.cos(T)*m/2,0,Math.sin(T)*m),x[o-1][1]=1==n.folds?new THREE.Vector3(M[0][2].x-Math.cos(P)*y,0,M[0][2].z+Math.sin(P)*y):M[0][2],M[0][3]=1==n.folds?new THREE.Vector3(0,0,0):new THREE.Vector3(d-i-R,0,0),T=2==n.folds?(n.angles[1]/2-n.angles[4]/2-90)*Math.PI/180:1==n.folds?(n.angles[1]-90)*Math.PI/180:(n.angles[1]/2-90)*Math.PI/180,x[o-1][0]=new THREE.Vector3(M[0][3].x-Math.cos(T)*y,0,M[0][3].z+Math.sin(T)*y)}n.folds>=2&&(M[1]=[],x[o-2]=[],M[1][0]=M[0][3],x[o-2][3]=x[o-1][0],T=(135+3*n.angles[1]/4)*Math.PI/180,M[1][1]=new THREE.Vector3(d-i-Math.cos(T)*m,0,Math.sin(T)*m),x[o-2][2]=M[1][1],T=0,n.folds>2?(T=(45-3*n.angles[4]/4)*Math.PI/180,M[1][2]=new THREE.Vector3(2*d-i+R-Math.cos(T)*m,0,Math.sin(T)*m),x[o-2][1]=M[1][2],M[1][3]=new THREE.Vector3(2*d-i+R,0,0),T=(n.angles[4]/2-90)*Math.PI/180,x[o-2][0]=new THREE.Vector3(M[1][3].x+Math.cos(T)*y*1.25,0,M[1][3].z+Math.sin(T)*y*1.25)):(T=(135-n.angles[4]/4+n.angles[1]/2)*Math.PI/180,M[1][1]=new THREE.Vector3(d-i-Math.cos(T)*m/2,0,Math.sin(T)*m),x[0][2]=M[1][1],T=(180-n.angles[4])*Math.PI/180,M[1][2]=M[1][3]=new THREE.Vector3(d-i-Math.cos(T)*d,0,Math.sin(T)*d),T=(n.angles[4]-90)*Math.PI/180,x[0][0]=x[0][1]=new THREE.Vector3(M[1][3].x+Math.cos(T)*y,0,M[1][3].z+Math.sin(T)*y))),n.folds>2&&(M[2]=[],x[0]=[],M[2][0]=M[1][3],x[0][3]=x[1][0],T=(135-1*n.angles[4]/4)*Math.PI/180,M[2][1]=new THREE.Vector3(2*d-i-0*Math.cos(T),0,Math.sin(T)*m),x[0][2]=M[2][1],T=(180-n.angles[4])*Math.PI/180,M[2][2]=M[2][3]=new THREE.Vector3(2*d-i-Math.cos(T)*d,0,Math.sin(T)*d),T=(n.angles[4]-90)*Math.PI/180,x[0][0]=x[0][1]=new THREE.Vector3(M[2][3].x+Math.cos(T)*y,0,M[2][3].z+Math.sin(T)*y));for(var e=0;e<n.folds;e++){E[e]=new THREE.CubicBezierCurve3(M[e][0],M[e][1],M[e][2],M[e][3]),g[e]=E[e].getPoints(n.segments);for(var t,a=g[e][0],s=1;s<g[e].length;s++)t=g[e][s],w+=t.distanceTo(a),I.push(w),a=t;f[e]=new THREE.CubicBezierCurve3(x[e][0],x[e][1],x[e][2],x[e][3]),v[e]=f[e].getPoints(n.segments)}}();var H=n.geometry,S=o*s+1,z=8;H.vertices[0].z=H.vertices[2].z=H.vertices[z+2*S-1].z=H.vertices[z+3*S-1].z=H.vertices[z+5*S-1].z=H.vertices[z+6*S-1].z=g[o-1][s].z,H.vertices[0].x=H.vertices[2].x=H.vertices[z+2*S-1].x=H.vertices[z+3*S-1].x=H.vertices[z+5*S-1].x=H.vertices[z+6*S-1].x=g[o-1][s].x,H.vertices[1].z=H.vertices[3].z=H.vertices[z+S-1].z=H.vertices[z+4*S-1].z=H.vertices[z+6*S].z=H.vertices[z+7*S].z=v[0][0].z,H.vertices[1].x=H.vertices[3].x=H.vertices[z+S-1].x=H.vertices[z+4*S-1].x=H.vertices[z+6*S].x=H.vertices[z+7*S].x=v[0][0].x,H.vertices[5].z=H.vertices[7].z=H.vertices[z+S].z=H.vertices[z+2*S].z=H.vertices[z+4*S].z=H.vertices[z+5*S].z=g[0][0].z,H.vertices[5].x=H.vertices[7].x=H.vertices[z+S].x=H.vertices[z+2*S].x=H.vertices[z+4*S].x=H.vertices[z+5*S].x=g[0][0].x,H.vertices[4].z=H.vertices[6].z=H.vertices[z].z=H.vertices[z+3*S].z=H.vertices[z+7*S-1].z=H.vertices[z+8*S-1].z=v[o-1][s].z,H.vertices[4].x=H.vertices[6].x=H.vertices[z].x=H.vertices[z+3*S].x=H.vertices[z+7*S-1].x=H.vertices[z+8*S-1].x=v[o-1][s].x;var A=H.vertices.length;z++;for(var C=0;C<o;C++)for(var O=0==C,L=O?s-1:s,B=0;B<L;B++)H.vertices[z].z=H.vertices[z+3*S].z=H.vertices[A-z+7-S].z=H.vertices[A-z+7].z=v[o-1-C][L-B].z,H.vertices[z].x=H.vertices[z+3*S].x=H.vertices[A-z+7-S].x=H.vertices[A-z+7].x=v[o-1-C][L-B].x,H.vertices[z+S].z=H.vertices[z+2*S].z=H.vertices[z+4*S].z=H.vertices[z+5*S].z=g[C][B+O].z,H.vertices[z+S].x=H.vertices[z+2*S].x=H.vertices[z+4*S].x=H.vertices[z+5*S].x=g[C][B+O].x,z++;var V=H.faceVertexUvs[0],k=H.faces,F=0;for(B=0;B<V.length;B++)if(k[B].materialIndex==e.MATERIAL_FACE.FRONT){var _=I[F]/w;B%2==0?(V[B][0].x=V[B][1].x=V[B+1][0].x=_,F++):V[B-1][2].x=V[B][1].x=V[B][2].x=_}else if(k[B].materialIndex==e.MATERIAL_FACE.BACK){_=1-I[F]/w;B%2==0?(V[B][0].x=V[B][1].x=V[B+1][0].x=_,F--):V[B-1][2].x=V[B][1].x=V[B][2].x=_}H.computeBoundingBox();var j=Math.abs(H.boundingBox.min.x-H.boundingBox.max.x),D=Math.abs(H.boundingBox.min.z-H.boundingBox.max.z);Math.sqrt(j*j+D*D);n.scale.x=n.scale.z=d*n.folds/w,H.computeBoundingSphere(),H.verticesNeedUpdate=!0,H.computeFaceNormals(),H.computeVertexNormals(),H.uvsNeedUpdate=!0,H.normalsNeedUpdate=!0,E.forEach((function(e){null})),f.forEach((function(e){null})),v.forEach((function(e){null})),g.forEach((function(e){null}))},FlexBoxPaper}(e.BoxPaper);e.FlexBoxPaper=a;var s=function(t){function Bundle(e,n){e=e||{},t.call(this),this.type="Bundle",null!=n&&n.add(this)}return e.__extends(Bundle,t),Bundle}(THREE.Group);e.Bundle=s}(MOCKUP||(MOCKUP={})),function(e){var t=function(t){function Ground(n,a){n=n||{};this._textureRepeat=null==n.textureRepeat?50:n.textureRepeat,n.skipMaterials=!0,n.bumpScale=null==n.bumpScale?.1:n.bumpScale,n.shininess=null==n.shininess?0:n.shininess,t.call(this,n,a),this.receiveShadow=!0,this.angles=null,this.frontImage(null==n.frontImage?e.defaults.groundTexture:n.frontImage),this.type="Ground"}return e.__extends(Ground,t),Ground.prototype.frontImage=function(e){if(null==e)return Ground.__super.frontImage.call(this,e);Ground.__super.frontImage.call(this,e)},e.PlanePaper.prototype.frontBump=null,Ground.prototype.textureRepeat=function(e){if(null==e)return this._textureRepeat;this._textureRepeat=e,null!==this.material.map&&this.material.map.repeat.set(e,e)},Ground}(e.PlanePaper);e.Ground=t}(MOCKUP||(MOCKUP={})),MOCKUP.inchTomm=function(e){return 25.4*e},MOCKUP.mmToInch=function(e){return e/25.4},MOCKUP.clearChild=function(e){var t,n=e.material;if(e.parent.remove(e),null!=e.dispose&&e.dispose(),null!=e.geometry&&e.geometry.dispose(),null!=n){if(null==n.materials)n.map&&(t=n.map,n.dispose(),t.dispose()),n.bumpMap&&(t=n.bumpMap,n.dispose(),t.dispose());else for(var a=0;a<n.materials.length;a++)n.materials[a]&&(n.materials[a].map&&(t=n.materials[a].map,n.materials[a].dispose(),t.dispose()),n.materials[a].bumpMap&&(t=n.materials[a].bumpMap,n.materials[a].dispose(),t.dispose())),n.materials[a]=null;n=null,t=null}},THREE.OrbitControls=function(e,t){this.object=e,this.domElement=null!=t?t:document,this.enabled=!0,this.target=new THREE.Vector3,this.center=this.target,this.noZoom=!1,this.zoomSpeed=1,this.minDistance=0,this.maxDistance=1/0,this.minZoom=0,this.maxZoom=1/0,this.noRotate=!1,this.rotateSpeed=1,this.noPan=!1,this.keyPanSpeed=7,this.autoRotate=!1,this.autoRotateSpeed=2,this.minPolarAngle=0,this.maxPolarAngle=Math.PI,this.minAzimuthAngle=-1/0,this.maxAzimuthAngle=1/0,this.noKeys=!1,this.keys={LEFT:37,UP:38,RIGHT:39,BOTTOM:40},this.mouseButtons={ORBIT:THREE.MOUSE.LEFT,ZOOM:THREE.MOUSE.MIDDLE,PAN:THREE.MOUSE.RIGHT};var n,a,s=this,o=1e-6,r=new THREE.Vector2,i=new THREE.Vector2,p=new THREE.Vector2,m=new THREE.Vector2,d=new THREE.Vector2,E=new THREE.Vector2,f=new THREE.Vector3,g=new THREE.Vector3,v=new THREE.Vector2,M=new THREE.Vector2,x=new THREE.Vector2,T=0,y=0,b=1,R=new THREE.Vector3,P=new THREE.Vector3,w=new THREE.Quaternion,I=-1,H=0,S=1,z=2,A=3,C=4,O=5,L=I;this.target0=this.target.clone(),this.position0=this.object.position.clone(),this.zoom0=this.object.zoom;var B=(new THREE.Quaternion).setFromUnitVectors(e.up,new THREE.Vector3(0,1,0)),V=B.clone().inverse(),k={type:"change"},F={type:"start"},_={type:"end"};function getAutoRotationAngle(){return 2*Math.PI/60/60*s.autoRotateSpeed}function getZoomScale(){return Math.pow(.95,s.zoomSpeed)}function onMouseDown(e){if(!1!==s.enabled){if(e.preventDefault(),e.button===s.mouseButtons.ORBIT){if(!0===s.noRotate)return;L=H,r.set(e.clientX,e.clientY)}else if(e.button===s.mouseButtons.ZOOM){if(!0===s.noZoom)return;L=S,v.set(e.clientX,e.clientY)}else if(e.button===s.mouseButtons.PAN){if(!0===s.noPan)return;L=z,m.set(e.clientX,e.clientY)}L!==I&&(document.addEventListener("mousemove",onMouseMove,!1),document.addEventListener("mouseup",onMouseUp,!1),document.addEventListener("mouseout",onMouseUp,!1),s.dispatchEvent(F))}}function onMouseMove(e){if(!1!==s.enabled){e.preventDefault();var t=s.domElement===document?s.domElement.body:s.domElement;if(L===H){if(!0===s.noRotate)return;i.set(e.clientX,e.clientY),p.subVectors(i,r),s.rotateLeft(2*Math.PI*p.x/t.clientWidth*s.rotateSpeed),s.rotateUp(2*Math.PI*p.y/t.clientHeight*s.rotateSpeed),r.copy(i)}else if(L===S){if(!0===s.noZoom)return;M.set(e.clientX,e.clientY),x.subVectors(M,v),x.y>0?s.dollyIn():x.y<0&&s.dollyOut(),v.copy(M)}else if(L===z){if(!0===s.noPan)return;d.set(e.clientX,e.clientY),E.subVectors(d,m),s.pan(E.x,E.y),m.copy(d)}L!==I&&s.update()}}function onMouseUp(){!1!==s.enabled&&(document.removeEventListener("mousemove",onMouseMove,!1),document.removeEventListener("mouseup",onMouseUp,!1),document.removeEventListener("mouseout",onMouseUp,!1),s.dispatchEvent(_),L=I)}function onMouseWheel(e){if(!1!==s.enabled&&!0!==s.noZoom&&L===I){e.preventDefault(),e.stopPropagation();var t=0;null!=e.wheelDelta?t=e.wheelDelta:null!=e.detail&&(t=-e.detail),t>0?s.dollyOut():t<0&&s.dollyIn(),s.update(),s.dispatchEvent(F),s.dispatchEvent(_),s.zoomCallback&&s.zoomCallback()}}function onKeyDown(e){if(!1!==s.enabled&&!0!==s.noKeys&&!0!==s.noPan)switch(e.keyCode){case s.keys.UP:s.pan(0,s.keyPanSpeed),s.update();break;case s.keys.BOTTOM:s.pan(0,-s.keyPanSpeed),s.update();break;case s.keys.LEFT:s.pan(s.keyPanSpeed,0),s.update();break;case s.keys.RIGHT:s.pan(-s.keyPanSpeed,0),s.update()}}function touchstart(e){if(!1!==s.enabled){var t=e.touches.length;switch(s.mouseButtons.PAN==THREE.MOUSE.LEFT&&(t=3),t){case 4:if(!0===s.noRotate)return;L=A,r.set(e.touches[0].pageX,e.touches[0].pageY);break;case 2:if(!0===s.noZoom)return;L=C;var n=e.touches[0].pageX-e.touches[1].pageX,a=e.touches[0].pageY-e.touches[1].pageY,o=Math.sqrt(n*n+a*a);v.set(0,o);break;case 3:if(!0===s.noPan)return;L=O,m.set(e.touches[0].pageX,e.touches[0].pageY);break;default:L=I}L!==I&&s.dispatchEvent(F)}}function touchmove(e){if(!1!==s.enabled){var t=s.domElement===document?s.domElement.body:s.domElement,n=e.touches.length;switch(s.mouseButtons.PAN==THREE.MOUSE.LEFT&&(n=3),n){case 4:if(!0===s.noRotate)return;if(L!==A)return;e.preventDefault(),e.stopPropagation(),i.set(e.touches[0].pageX,e.touches[0].pageY),p.subVectors(i,r),s.rotateLeft(2*Math.PI*p.x/t.clientWidth*s.rotateSpeed),s.rotateUp(2*Math.PI*p.y/t.clientHeight*s.rotateSpeed),r.copy(i),s.update();break;case 2:if(!0===s.noZoom)return;if(L!==C)return;e.preventDefault(),e.stopPropagation();var a=e.touches[0].pageX-e.touches[1].pageX,o=e.touches[0].pageY-e.touches[1].pageY,f=Math.sqrt(a*a+o*o);M.set(0,f),x.subVectors(M,v),x.y>0?s.dollyOut():x.y<0&&s.dollyIn(),v.copy(M),s.update();break;case 3:if(!0===s.noPan)return;if(L!==O)return;e.preventDefault(),e.stopPropagation(),d.set(e.touches[0].pageX,e.touches[0].pageY),E.subVectors(d,m),s.pan(E.x,E.y),m.copy(d),s.update();break;default:L=I}}}function touchend(){!1!==s.enabled&&(s.dispatchEvent(_),L=I)}function suppressEvent(e){e.preventDefault()}this.rotateLeft=function(e){null==e&&(e=getAutoRotationAngle()),y-=e},this.rotateUp=function(e){null==e&&(e=getAutoRotationAngle()),T-=e},this.panLeft=function(e){var t=this.object.matrix.elements;f.set(t[0],t[1],t[2]),f.multiplyScalar(-e),R.add(f)},this.panUp=function(e){var t=this.object.matrix.elements;f.set(t[4],t[5],t[6]),f.multiplyScalar(e),R.add(f)},this.pan=function(e,t){var n=s.domElement===document?s.domElement.body:s.domElement;if(s.object instanceof THREE.PerspectiveCamera){var a=s.object.position.clone().sub(s.target).length();a*=Math.tan(s.object.fov/2*Math.PI/180),s.panLeft(2*e*a/n.clientHeight),s.panUp(2*t*a/n.clientHeight)}else s.object instanceof THREE.OrthographicCamera?(s.panLeft(e*(s.object.right-s.object.left)/n.clientWidth),s.panUp(t*(s.object.top-s.object.bottom)/n.clientHeight)):console.warn("WARNING: OrbitControls.js encountered an unknown camera type - pan disabled.")},this.dollyIn=function(e){null==e&&(e=getZoomScale()),s.object instanceof THREE.PerspectiveCamera?b/=e:s.object instanceof THREE.OrthographicCamera?(s.object.zoom=Math.max(this.minZoom,Math.min(this.maxZoom,this.object.zoom*e)),s.object.updateProjectionMatrix(),s.dispatchEvent(k)):console.warn("WARNING: OrbitControls.js encountered an unknown camera type - dolly/zoom disabled.")},this.dollyOut=function(e){null==e&&(e=getZoomScale()),s.object instanceof THREE.PerspectiveCamera?b*=e:s.object instanceof THREE.OrthographicCamera?(s.object.zoom=Math.max(this.minZoom,Math.min(this.maxZoom,this.object.zoom/e)),s.object.updateProjectionMatrix(),s.dispatchEvent(k)):console.warn("WARNING: OrbitControls.js encountered an unknown camera type - dolly/zoom disabled.")},this.update=function(){var e=this.object.position;g.copy(e).sub(this.target),g.applyQuaternion(B),n=Math.atan2(g.x,g.z),a=Math.atan2(Math.sqrt(g.x*g.x+g.z*g.z),g.y),this.autoRotate&&L===I&&this.rotateLeft(getAutoRotationAngle()),n+=y,a+=T,n=Math.max(this.minAzimuthAngle,Math.min(this.maxAzimuthAngle,n)),a=Math.max(this.minPolarAngle,Math.min(this.maxPolarAngle,a)),a=Math.max(o,Math.min(Math.PI-o,a));var t=g.length()*b;t=Math.max(this.minDistance,Math.min(this.maxDistance,t)),this.target.add(R),g.x=t*Math.sin(a)*Math.sin(n),g.y=t*Math.cos(a),g.z=t*Math.sin(a)*Math.cos(n),g.applyQuaternion(V),e.copy(this.target).add(g),this.object.lookAt(this.target),y=0,T=0,b=1,R.set(0,0,0),(P.distanceToSquared(this.object.position)>o||8*(1-w.dot(this.object.quaternion))>o)&&(this.dispatchEvent(k),P.copy(this.object.position),w.copy(this.object.quaternion))},this.reset=function(){L=I,this.target.copy(this.target0),this.object.position.copy(this.position0),this.object.zoom=this.zoom0,this.object.updateProjectionMatrix(),this.dispatchEvent(k),this.update()},this.getPolarAngle=function(){return a},this.getAzimuthalAngle=function(){return n},this.dispose=function(){this.domElement.removeEventListener("contextmenu",suppressEvent,!1),this.domElement.removeEventListener("mousedown",onMouseDown,!1),this.domElement.removeEventListener("mousewheel",onMouseWheel,!1),this.domElement.removeEventListener("DOMMouseScroll",onMouseWheel,!1),this.domElement.removeEventListener("touchstart",touchstart,!1),this.domElement.removeEventListener("touchend",touchend,!1),this.domElement.removeEventListener("touchmove",touchmove,!1),window.removeEventListener("keydown",onKeyDown,!1)},this.domElement.addEventListener("contextmenu",suppressEvent,!1),this.domElement.addEventListener("mousedown",onMouseDown,!1),this.domElement.addEventListener("mousewheel",onMouseWheel,!1),this.domElement.addEventListener("DOMMouseScroll",onMouseWheel,!1),this.domElement.addEventListener("touchstart",touchstart,!1),this.domElement.addEventListener("touchend",touchend,!1),this.domElement.addEventListener("touchmove",touchmove,!1),window.addEventListener("keydown",onKeyDown,!1),this.update()},THREE.OrbitControls.prototype=Object.create(THREE.EventDispatcher.prototype),THREE.OrbitControls.prototype.constructor=THREE.OrbitControls,THREE.CSS3DObject=function(e){THREE.Object3D.call(this),this.element=e,this.element.style.position="absolute",this.addEventListener("removed",(function(e){null!==this.element.parentNode&&this.element.parentNode.removeChild(this.element)}))},THREE.CSS3DObject.prototype=Object.create(THREE.Object3D.prototype),THREE.CSS3DObject.prototype.constructor=THREE.CSS3DObject,THREE.CSS3DSprite=function(e){THREE.CSS3DObject.call(this,e)},THREE.CSS3DSprite.prototype=Object.create(THREE.CSS3DObject.prototype),THREE.CSS3DSprite.prototype.constructor=THREE.CSS3DSprite,THREE.CSS3DRenderer=function(){var e,t,n,a;console.log("THREE.CSS3DRenderer",THREE.REVISION);var s=new THREE.Matrix4,o={camera:{fov:0,style:""},objects:{}},r=document.createElement("div");r.style.overflow="hidden",r.style.WebkitTransformStyle="preserve-3d",r.style.MozTransformStyle="preserve-3d",r.style.oTransformStyle="preserve-3d",r.style.transformStyle="preserve-3d",this.domElement=r;var i=document.createElement("div");i.style.WebkitTransformStyle="preserve-3d",i.style.MozTransformStyle="preserve-3d",i.style.oTransformStyle="preserve-3d",i.style.transformStyle="preserve-3d",r.appendChild(i),this.setClearColor=function(){},this.getSize=function(){return{width:e,height:t}},this.setSize=function(s,o){n=(e=s)/2,a=(t=o)/2,r.style.width=s+"px",r.style.height=o+"px",i.style.width=s+"px",i.style.height=o+"px"};var h=function(e){return Math.abs(e)<Number.EPSILON?0:e},u=function(e){var t=e.elements;return"matrix3d("+h(t[0])+","+h(-t[1])+","+h(t[2])+","+h(t[3])+","+h(t[4])+","+h(-t[5])+","+h(t[6])+","+h(t[7])+","+h(t[8])+","+h(-t[9])+","+h(t[10])+","+h(t[11])+","+h(t[12])+","+h(-t[13])+","+h(t[14])+","+h(t[15])+")"},c=function(e){var t=e.elements;return"translate3d(-50%,-50%,0) matrix3d("+h(t[0])+","+h(t[1])+","+h(t[2])+","+h(t[3])+","+h(-t[4])+","+h(-t[5])+","+h(-t[6])+","+h(-t[7])+","+h(t[8])+","+h(t[9])+","+h(t[10])+","+h(t[11])+","+h(t[12])+","+h(t[13])+","+h(t[14])+","+h(t[15])+")"},l=function(e,t){if(e instanceof THREE.CSS3DObject){var n;e instanceof THREE.CSS3DSprite?(s.copy(t.matrixWorldInverse),s.transpose(),s.copyPosition(e.matrixWorld),s.scale(e.scale),s.elements[3]=0,s.elements[7]=0,s.elements[11]=0,s.elements[15]=1,n=c(s)):n=c(e.matrixWorld);var a=e.element,r=o.objects[e.id];void 0!==r&&r===n||(a.style.WebkitTransform=n,a.style.MozTransform=n,a.style.oTransform=n,a.style.transform=n,o.objects[e.id]=n),a.parentNode!==i&&i.appendChild(a)}for(var p=0,m=e.children.length;p<m;p++)l(e.children[p],t)};this.render=function(e,s){var p=.5/Math.tan(THREE.Math.degToRad(.5*s.fov))*t;o.camera.fov!==p&&(r.style.WebkitPerspective=p+"px",r.style.MozPerspective=p+"px",r.style.oPerspective=p+"px",r.style.perspective=p+"px",o.camera.fov=p),e.updateMatrixWorld(),null===s.parent&&s.updateMatrixWorld(),s.matrixWorldInverse.getInverse(s.matrixWorld);var m="translate3d(0,0,"+p+"px)"+u(s.matrixWorldInverse)+" translate3d("+n+"px,"+a+"px, 0)";o.camera.style!==m&&(i.style.WebkitTransform=m,i.style.MozTransform=m,i.style.oTransform=m,i.style.transform=m,o.camera.style=m),l(e,s)}};